/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.mail;

import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.upm.mail.ProductUserLists;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.security.Principal;
import java.util.Set;

public class JiraUserLists
implements ProductUserLists {
    private final UserUtil userUtil;
    private final UserManager userManager;
    private final Function<Principal, UserKey> toUserKeys = new Function<Principal, UserKey>(){

        public UserKey apply(Principal user) {
            return JiraUserLists.this.userManager.getUserProfile(user.getName()).getUserKey();
        }
    };

    public JiraUserLists(UserUtil userUtil, UserManager userManager) {
        this.userUtil = (UserUtil)Preconditions.checkNotNull((Object)userUtil, (Object)"userUtil");
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager, (Object)"userManager");
    }

    @Override
    public Set<UserKey> getSystemAdmins() {
        return ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)this.userUtil.getJiraSystemAdministrators(), this.toUserKeys));
    }

    @Override
    public Set<UserKey> getAdminsAndSystemAdmins() {
        return ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)this.userUtil.getJiraAdministrators(), this.toUserKeys));
    }
}

