/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.log;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.upm.api.log.AuditLogEntry;
import com.atlassian.upm.api.log.EntryType;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.core.log.PluginInstallerPluginLogAccessor;
import com.atlassian.upm.core.log.PluginSettingsAuditLogAccessor;
import com.atlassian.upm.core.log.PluginSettingsAuditLogService;
import com.atlassian.upm.rest.UpmUriBuilder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.sun.syndication.feed.atom.Feed;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class UpmAuditLogService
extends PluginSettingsAuditLogService {
    public static final String KEY_PREFIX = "com.atlassian.upm.log.PluginSettingsAuditLogService:log:";
    private final PluginInstallerPluginLogAccessor pipLogAccessor;

    public UpmAuditLogService(I18nResolver i18nResolver, ApplicationProperties applicationProperties, UserManager userManager, PluginSettingsFactory pluginSettingsFactory, TransactionTemplate txTemplate, UpmUriBuilder uriBuilder, PluginInstallerPluginLogAccessor pipLogAccessor, PluginSettingsAuditLogAccessor.Clock clock) {
        super(i18nResolver, applicationProperties, userManager, pluginSettingsFactory, txTemplate, uriBuilder, clock, KEY_PREFIX);
        this.pipLogAccessor = (PluginInstallerPluginLogAccessor)Preconditions.checkNotNull((Object)pipLogAccessor, (Object)"pipLogAccessor");
    }

    public UpmAuditLogService(I18nResolver i18nResolver, ApplicationProperties applicationProperties, UserManager userManager, PluginSettingsFactory pluginSettingsFactory, TransactionTemplate txTemplate, UpmUriBuilder uriBuilder, PluginInstallerPluginLogAccessor pipLogAccessor) {
        super(i18nResolver, applicationProperties, userManager, pluginSettingsFactory, txTemplate, uriBuilder, KEY_PREFIX);
        this.pipLogAccessor = (PluginInstallerPluginLogAccessor)Preconditions.checkNotNull((Object)pipLogAccessor, (Object)"pipLogAccessor");
    }

    @Override
    public synchronized Iterable<AuditLogEntry> getLogEntries() {
        this.updateFromPipLogAccessor();
        return super.getLogEntries();
    }

    @Override
    public synchronized Collection<AuditLogEntry> getLogEntries(Integer maxResults, Integer startIndex) {
        this.updateFromPipLogAccessor();
        return super.getLogEntries(maxResults, startIndex);
    }

    @Override
    public synchronized Iterable<AuditLogEntry> getLogEntries(Integer maxResults, Integer startIndex, Set<EntryType> entryTypes) {
        this.updateFromPipLogAccessor();
        return super.getLogEntries(maxResults, startIndex, entryTypes);
    }

    @Override
    public synchronized Feed getFeed() {
        this.updateFromPipLogAccessor();
        return super.getFeed();
    }

    @Override
    public synchronized Feed getFeed(Integer maxResults, Integer startIndex) {
        this.updateFromPipLogAccessor();
        return super.getFeed(maxResults, startIndex);
    }

    private synchronized void updateFromPipLogAccessor() {
        Iterable<AuditLogEntry> newPipEntries = this.pipLogAccessor.getLogEntries(Option.some(this.getLastRetrieved()));
        if (!Iterables.isEmpty(newPipEntries)) {
            ImmutableList allEntries = ImmutableList.builder().addAll(newPipEntries).addAll(super.getLogEntries(null, null)).build();
            List sortedEntries = Ordering.natural().reverse().sortedCopy((Iterable)allEntries);
            this.setLogEntries(sortedEntries);
        }
    }
}

