/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.license.internal;

import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.core.Plugin;
import com.atlassian.upm.core.PluginRetriever;
import com.atlassian.upm.core.impl.UpmAppManager;
import com.atlassian.upm.license.LicensedPlugins;
import com.atlassian.upm.license.PluginLicenses;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Iterator;

public class PluginLicensesInternal {
    public static final Function<PluginLicense, String> toPluginKey() {
        return new Function<PluginLicense, String>(){

            public String apply(PluginLicense pluginLicense) {
                return pluginLicense.getPluginKey();
            }
        };
    }

    public static Function<PluginLicense, Option<String>> licensePluginSen() {
        return new Function<PluginLicense, Option<String>>(){

            public Option<String> apply(PluginLicense pluginLicense) {
                return pluginLicense.getSupportEntitlementNumber();
            }
        };
    }

    public static Predicate<PluginLicense> isEditionMismatch() {
        return Predicates.or(PluginLicenses.hasError(LicenseError.USER_MISMATCH), PluginLicenses.hasError(LicenseError.EDITION_MISMATCH));
    }

    public static Predicate<PluginLicense> isRecentlyExpiredEvaluation(PluginRetriever pluginRetriever, UpmAppManager appManager) {
        return Predicates.and(PluginLicensesInternal.isRecentExpiredEvaluationCoreLogic(), (Predicate)Predicates.not(PluginLicensesInternal.isUninstalledLegacyPlugin(pluginRetriever, appManager)));
    }

    public static Predicate<PluginLicense> isRecentlyExpiredEvaluation(Option<Plugin> plugin) {
        return Predicates.and(PluginLicensesInternal.isRecentExpiredEvaluationCoreLogic(), (Predicate)Predicates.not(PluginLicensesInternal.isUninstalledLegacyPlugin(plugin)));
    }

    private static Predicate<PluginLicense> isRecentExpiredEvaluationCoreLogic() {
        return Predicates.and((Predicate[])new Predicate[]{PluginLicenses.hasError(LicenseError.EXPIRED), PluginLicenses.isRecentlyExpired(), PluginLicenses.isEvaluation()});
    }

    public static Predicate<PluginLicense> isNearlyExpiredEvaluation(PluginRetriever pluginRetriever, UpmAppManager appManager) {
        return Predicates.and(PluginLicensesInternal.isNearlyExpiredEvaluationCoreLogic(), (Predicate)Predicates.not(PluginLicensesInternal.isUninstalledLegacyPlugin(pluginRetriever, appManager)));
    }

    public static Predicate<PluginLicense> isNearlyExpiredEvaluation(Option<Plugin> plugin) {
        return Predicates.and(PluginLicensesInternal.isNearlyExpiredEvaluationCoreLogic(), (Predicate)Predicates.not(PluginLicensesInternal.isUninstalledLegacyPlugin(plugin)));
    }

    private static Predicate<PluginLicense> isNearlyExpiredEvaluationCoreLogic() {
        return Predicates.and(PluginLicenses.isNearlyExpired(), PluginLicenses.isEvaluation());
    }

    public static Predicate<PluginLicense> isMaintenanceRecentlyExpired(PluginRetriever pluginRetriever, UpmAppManager appManager) {
        return Predicates.and((Predicate[])new Predicate[]{Predicates.not(PluginLicense::isDataCenter), PluginLicensesInternal.isMaintenanceRecentlyExpiredCoreLogic(), Predicates.not(PluginLicensesInternal.isUninstalledLegacyPlugin(pluginRetriever, appManager))});
    }

    public static Predicate<PluginLicense> isMaintenanceRecentlyExpired(Option<Plugin> plugin) {
        return Predicates.and((Predicate[])new Predicate[]{Predicates.not(PluginLicense::isDataCenter), PluginLicensesInternal.isMaintenanceRecentlyExpiredCoreLogic(), Predicates.not(PluginLicensesInternal.isUninstalledLegacyPlugin(plugin))});
    }

    private static Predicate<PluginLicense> isMaintenanceRecentlyExpiredCoreLogic() {
        return Predicates.and((Predicate[])new Predicate[]{Predicates.not(PluginLicense::isDataCenter), PluginLicenses.isRecentlyMaintenanceExpired(), Predicates.not(PluginLicenses.isEvaluation())});
    }

    public static Predicate<PluginLicense> isMaintenanceNearlyExpired(PluginRetriever pluginRetriever, UpmAppManager appManager) {
        return Predicates.and((Predicate[])new Predicate[]{Predicates.not(PluginLicense::isDataCenter), PluginLicensesInternal.isMaintenanceNearlyExpired(), Predicates.not(PluginLicensesInternal.isUninstalledLegacyPlugin(pluginRetriever, appManager))});
    }

    public static Predicate<PluginLicense> isMaintenanceNearlyExpired(Option<Plugin> plugin) {
        return Predicates.and((Predicate[])new Predicate[]{Predicates.not(PluginLicense::isDataCenter), PluginLicensesInternal.isMaintenanceNearlyExpired(), Predicates.not(PluginLicensesInternal.isUninstalledLegacyPlugin(plugin))});
    }

    private static Predicate<PluginLicense> isMaintenanceNearlyExpired() {
        return Predicates.and(PluginLicenses.isNearlyMaintenanceExpired(), (Predicate)Predicates.not(PluginLicenses.isEvaluation()));
    }

    private static Predicate<PluginLicense> isLicenseNearlyExpired() {
        return Predicates.and(PluginLicenses.isNearlyExpired(), (Predicate)Predicates.not(PluginLicenses.isEvaluation()));
    }

    private static Predicate<PluginLicense> isLicenseRecentlyExpired() {
        return Predicates.and(PluginLicenses.isRecentlyExpired(), (Predicate)Predicates.not(PluginLicenses.isEvaluation()));
    }

    public static Predicate<PluginLicense> isDataCenterLicenseRecentlyExpired(PluginRetriever pluginRetriever, UpmAppManager appManager) {
        return Predicates.and((Predicate[])new Predicate[]{PluginLicense::isDataCenter, PluginLicensesInternal.isLicenseRecentlyExpired(), Predicates.not(PluginLicensesInternal.isUninstalledLegacyPlugin(pluginRetriever, appManager))});
    }

    public static Predicate<PluginLicense> isDataCenterLicenseNearlyExpired(PluginRetriever pluginRetriever, UpmAppManager appManager) {
        return Predicates.and((Predicate[])new Predicate[]{PluginLicense::isDataCenter, PluginLicensesInternal.isLicenseNearlyExpired(), Predicates.not(PluginLicensesInternal.isUninstalledLegacyPlugin(pluginRetriever, appManager))});
    }

    public static Predicate<PluginLicense> isDataCenterLicenseRecentlyExpired(Option<Plugin> plugin) {
        return Predicates.and((Predicate[])new Predicate[]{PluginLicense::isDataCenter, PluginLicensesInternal.isLicenseRecentlyExpired(), Predicates.not(PluginLicensesInternal.isUninstalledLegacyPlugin(plugin))});
    }

    public static Predicate<PluginLicense> isDataCenterLicenseNearlyExpired(Option<Plugin> plugin) {
        return Predicates.and((Predicate[])new Predicate[]{PluginLicense::isDataCenter, PluginLicensesInternal.isLicenseNearlyExpired(), Predicates.not(PluginLicensesInternal.isUninstalledLegacyPlugin(plugin))});
    }

    private static Predicate<PluginLicense> isUninstalledLegacyPlugin(final PluginRetriever pluginRetriever, final UpmAppManager appManager) {
        return new Predicate<PluginLicense>(){

            public boolean apply(PluginLicense license) {
                String pluginKey = license.getPluginKey();
                if (!LicensedPlugins.isLegacyLicensePlugin(pluginKey)) {
                    return false;
                }
                Iterator<Plugin> iterator = pluginRetriever.getPlugin(pluginKey).iterator();
                if (iterator.hasNext()) {
                    Plugin plugin = iterator.next();
                    return !LicensedPlugins.usesLicensing(plugin.getPlugin(), appManager);
                }
                return true;
            }
        };
    }

    public static Predicate<PluginLicense> isUninstalledLegacyPlugin(final Option<Plugin> plugin) {
        return new Predicate<PluginLicense>(){

            public boolean apply(PluginLicense license) {
                String pluginKey = license.getPluginKey();
                if (!LicensedPlugins.isLegacyLicensePlugin(pluginKey)) {
                    return false;
                }
                return !plugin.isDefined();
            }
        };
    }
}

