/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.core.rest.resources.install;

import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.api.util.Options;
import com.atlassian.upm.core.Plugin;
import com.atlassian.upm.core.PluginRetriever;
import com.atlassian.upm.core.async.AsyncTask;
import com.atlassian.upm.core.async.AsyncTaskStatus;
import com.atlassian.upm.core.async.AsyncTaskStatusUpdater;
import com.atlassian.upm.core.async.AsyncTaskType;
import com.atlassian.upm.core.rest.PluginRestUninstaller;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;

public class BulkUninstallTask
implements AsyncTask {
    private final Iterable<String> pluginKeys;
    private final PluginRetriever pluginRetriever;
    private final PluginRestUninstaller uninstaller;

    public BulkUninstallTask(Iterable<String> pluginKeys, PluginRetriever pluginRetriever, PluginRestUninstaller uninstaller) {
        this.pluginKeys = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(pluginKeys, (Object)"pluginKeys")));
        this.pluginRetriever = (PluginRetriever)Preconditions.checkNotNull((Object)pluginRetriever, (Object)"pluginRetriever");
        this.uninstaller = (PluginRestUninstaller)Preconditions.checkNotNull((Object)uninstaller, (Object)"installer");
    }

    @Override
    public AsyncTaskType getType() {
        return AsyncTaskType.UNINSTALL;
    }

    @Override
    public AsyncTaskStatus getInitialStatus() {
        return AsyncTaskStatus.empty();
    }

    @Override
    public AsyncTaskStatus run(final AsyncTaskStatusUpdater statusUpdater) throws Exception {
        Iterable<Plugin> plugins = Options.catOptions(Iterables.transform(this.pluginKeys, (Function)new Function<String, Option<Plugin>>(){

            public Option<Plugin> apply(String pk) {
                return BulkUninstallTask.this.pluginRetriever.getPlugin(pk);
            }
        }));
        PluginRestUninstaller.BulkUninstallProgressTracker tracker = new PluginRestUninstaller.BulkUninstallProgressTracker(){

            @Override
            public void notify(PluginRestUninstaller.BulkUninstallProgress progress) {
                statusUpdater.updateStatus(AsyncTaskStatus.builder().progress(Option.some(Float.valueOf((float)progress.getCompleted() / (float)progress.getTotal()))).build());
            }
        };
        return this.uninstaller.uninstall(plugins, tracker);
    }
}

