/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.core.rest.resources;

import com.atlassian.upm.core.Change;
import com.atlassian.upm.core.PluginRestartRequiredService;
import com.atlassian.upm.core.rest.representations.BasePluginRepresentationFactory;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/requires-restart")
public class ChangeRequiringRestartCollectionResource {
    private final BasePluginRepresentationFactory factory;
    private final PermissionEnforcer permissionEnforcer;
    private final PluginRestartRequiredService restartRequiredService;

    public ChangeRequiringRestartCollectionResource(PluginRestartRequiredService restartRequiredService, BasePluginRepresentationFactory factory, PermissionEnforcer permissionEnforcer) {
        this.restartRequiredService = (PluginRestartRequiredService)Preconditions.checkNotNull((Object)restartRequiredService, (Object)"restartRequiredService");
        this.permissionEnforcer = (PermissionEnforcer)Preconditions.checkNotNull((Object)permissionEnforcer, (Object)"permissionEnforcer");
        this.factory = (BasePluginRepresentationFactory)Preconditions.checkNotNull((Object)factory, (Object)"factory");
    }

    @GET
    @Produces(value={"application/vnd.atl.plugins.changes.requiring.restart+json"})
    public Response get() {
        Iterable filteredChanges = Iterables.filter(this.restartRequiredService.getRestartRequiredChanges(), (Predicate)new Predicate<Change>(){

            public boolean apply(Change change) {
                return ChangeRequiringRestartCollectionResource.this.permissionEnforcer.hasPermission(change.getRequiredPermission());
            }
        });
        return Response.ok((Object)this.factory.createChangesRequiringRestartRepresentation(filteredChanges)).build();
    }
}

