/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm;

import com.atlassian.upm.api.util.Option;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;

public abstract class SysCommon {
    public static final String PLUGIN_KEY_LIST_IGNORE_VALUE = "-";
    public static final String ATLASSIAN_CONNECT_XML_BUNDLE_ATTRIBUTE = "Remote-Plugin";
    public static final String ATLASSIAN_CONNECT_PLUGIN_KEY = "com.atlassian.plugins.atlassian-connect-plugin";

    public static Option<Iterable<String>> getPluginKeysFromSysProp(String propKey) {
        return Option.option(System.getProperty(propKey)).flatMap(new Function<String, Option<Iterable<String>>>(){

            public Option<Iterable<String>> apply(String pluginKeys) {
                if (pluginKeys.equals(SysCommon.PLUGIN_KEY_LIST_IGNORE_VALUE)) {
                    return Option.none();
                }
                ImmutableList.Builder keys = ImmutableList.builder();
                for (String key : pluginKeys.split(",")) {
                    keys.add((Object)key.trim());
                }
                return Option.some(keys.build());
            }
        });
    }
}

