/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.trackback;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class TrackbackUtils {
    private static Log log;
    private static int REGEX_OPTIONS;
    private static Pattern RDF_OUTER_PATTERN;
    private static Pattern RDF_INNER_PATTERN;
    private static Pattern DC_IDENTIFIER_PATTERN;
    private static Pattern TRACKBACK_PING_PATTERN;
    private static Pattern HREF_PATTERN;
    protected static final String MIME_TYPE_HTML = "text/html";
    protected static final String MIME_TYPE_XML = "text/xml";
    protected static final String MIME_CORRECT_TYPE_XML = "application/rss+xml;";
    protected static final String MIME_TYPE_XHTML = "application/xhtml+xml";
    private static final int MAX_RESULT_LENGTH = 102400;
    protected static final int HTTPCLIENT_SOCKET_TIMEOUT = 30000;

    public static String getTrackbackUrl(String remoteContent, String hyperlink) {
        Perl5Matcher matcher = new Perl5Matcher();
        PatternMatcherInput input = new PatternMatcherInput(remoteContent);
        while (matcher.contains(input, RDF_OUTER_PATTERN)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Found outer RDF text in hyperlink");
            }
            MatchResult result = matcher.getMatch();
            for (int i = 0; i < result.groups(); ++i) {
                String outerRdfText = result.group(i);
                Perl5Matcher rdfInnerMatcher = new Perl5Matcher();
                PatternMatcherInput outerRdfTextInput = new PatternMatcherInput(outerRdfText);
                while (rdfInnerMatcher.contains(outerRdfTextInput, RDF_INNER_PATTERN)) {
                    log.debug((Object)"Found inner RDF text in hyperlink");
                    MatchResult rdfOuterRdfTextResult = rdfInnerMatcher.getMatch();
                    for (int j = 0; j < rdfOuterRdfTextResult.groups(); ++j) {
                        Perl5Matcher dcIdentifierMatcher = new Perl5Matcher();
                        String innerRdfText = rdfOuterRdfTextResult.group(j);
                        PatternMatcherInput dcIdentifierInput = new PatternMatcherInput(innerRdfText);
                        if (!dcIdentifierMatcher.contains(dcIdentifierInput, DC_IDENTIFIER_PATTERN)) continue;
                        MatchResult dcIdentifierResult = dcIdentifierMatcher.getMatch();
                        String dcIdentifier = dcIdentifierResult.group(1);
                        if (dcIdentifier.equals(hyperlink)) {
                            log.debug((Object)"Matched dc:identifier to hyperlink");
                            Perl5Matcher trackbackPingMatcher = new Perl5Matcher();
                            PatternMatcherInput pingInput = new PatternMatcherInput(innerRdfText);
                            if (!trackbackPingMatcher.contains(pingInput, TRACKBACK_PING_PATTERN)) continue;
                            MatchResult pingResult = trackbackPingMatcher.getMatch();
                            String trackbackUrl = pingResult.group(1);
                            log.debug((Object)("Got trackback URL " + trackbackUrl));
                            return trackbackUrl;
                        }
                        log.debug((Object)("dc:identifier mismatch; expected '" + hyperlink + "', found '" + dcIdentifier + "', ignoring"));
                    }
                }
            }
        }
        return null;
    }

    public static String getUrlContent(String hyperlink) throws IOException {
        try {
            HttpClient client = new HttpClient();
            client.setTimeout(30000);
            GetMethod method = new GetMethod(hyperlink);
            method.addRequestHeader("Accepts", "text/html, text/xml,application/xhtml+xml");
            int statusCode = -1;
            try {
                statusCode = client.executeMethod((HttpMethod)method);
            }
            catch (HttpException e) {
                log.info((Object)("Problem retrieving content for '" + hyperlink + ": " + e.getMessage()));
                log.debug((Object)e.getMessage(), (Throwable)e);
                return null;
            }
            catch (SocketTimeoutException e) {
                log.info((Object)("Timeout exceeeded - unable to parse content from '" + hyperlink + ": " + e.getMessage()));
                log.debug((Object)e.getMessage(), (Throwable)e);
                return null;
            }
            if (statusCode == 200 && TrackbackUtils.isValidResponseContentType((HttpMethod)method)) {
                InputStream is = method.getResponseBodyAsStream();
                if (is == null) {
                    return null;
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                String s = null;
                StringBuffer result = new StringBuffer();
                while ((s = reader.readLine()) != null && result.length() < 102400) {
                    result.append(s);
                }
                is.close();
                method.releaseConnection();
                return result.toString();
            }
            return null;
        }
        catch (IllegalStateException e) {
            log.info((Object)("IllegalStateException whilst retrieving URL " + hyperlink + ". Exception " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    private static boolean isValidResponseContentType(HttpMethod method) {
        Header contentType = method.getResponseHeader("Content-type");
        String headerValue = contentType.getValue();
        return headerValue.startsWith(MIME_TYPE_HTML) || headerValue.startsWith(MIME_TYPE_XML) || headerValue.startsWith(MIME_CORRECT_TYPE_XML) || headerValue.startsWith(MIME_TYPE_XHTML);
    }

    public static List getHttpLinks(String html) {
        ArrayList<String> result = new ArrayList<String>();
        Perl5Matcher hrefMatcher = new Perl5Matcher();
        PatternMatcherInput input = new PatternMatcherInput(html);
        while (hrefMatcher.contains(input, HREF_PATTERN)) {
            MatchResult match = hrefMatcher.getMatch();
            if (match.groups() != 3) continue;
            String hyperlink = match.group(1);
            log.debug((Object)("Found hyperlink: " + hyperlink));
            result.add(hyperlink);
        }
        return result;
    }

    static {
        try {
            log = LogFactory.getLog((Class)TrackbackUtils.class);
            REGEX_OPTIONS = 17;
            RDF_OUTER_PATTERN = new Perl5Compiler().compile("(<rdf:RDF.*?</rdf:RDF>).*?", REGEX_OPTIONS);
            RDF_INNER_PATTERN = new Perl5Compiler().compile("(<rdf:Description.*?/>)", REGEX_OPTIONS);
            DC_IDENTIFIER_PATTERN = new Perl5Compiler().compile("dc:identifier=\"(.*?)\"");
            TRACKBACK_PING_PATTERN = new Perl5Compiler().compile("trackback:ping=\"(.*?)\"");
            HREF_PATTERN = new Perl5Compiler().compile("<\\s*a .*?href\\s*=\\s*\"(http([^\"]+).*?)\"\\s*>", REGEX_OPTIONS);
        }
        catch (MalformedPatternException e) {
            String message = "Error while initializing TrackbackUtils";
            log.error((Object)"Error while initializing TrackbackUtils", (Throwable)e);
            throw new RuntimeException("Error while initializing TrackbackUtils");
        }
    }
}

