/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.trackback;

import com.atlassian.trackback.Trackback;
import com.atlassian.trackback.TrackbackSender;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultTrackbackSender
implements TrackbackSender {
    private static Log log = LogFactory.getLog((Class)DefaultTrackbackSender.class);
    private static final String TRACKBACK_EXCERPT_PARAM = "excerpt";
    private static final String TRACKBACK_BLOG_NAME_PARAM = "blog_name";
    private static final String TRACKBACK_URL_PARAM = "url";
    private static final String TRACKBACK_TITLE_PARAM = "title";
    private static final Map requestHeaderMap;

    public void sendPing(String pingUrl, Trackback tb) throws IOException {
        HttpClient client = new HttpClient();
        client.setTimeout(30000);
        HttpMethod method = this.buildPostMethod(pingUrl, tb);
        int statusCode = client.executeMethod(method);
        if (statusCode != 200) {
            log.debug((Object)("Error writing trackback to " + pingUrl + ": " + statusCode + " response code."));
        }
    }

    public Map buildHttpHeaders(String pingUrl, Trackback tb) {
        return requestHeaderMap;
    }

    private HttpMethod buildPostMethod(String trackbackPingURL, Trackback tb) {
        PostMethod method = new PostMethod(trackbackPingURL);
        method.addParameter(TRACKBACK_URL_PARAM, tb.getUrl());
        if (tb.getTitle() != null) {
            method.addParameter(TRACKBACK_TITLE_PARAM, tb.getTitle());
        }
        if (tb.getBlogName() != null) {
            method.addParameter(TRACKBACK_BLOG_NAME_PARAM, tb.getBlogName());
        }
        if (tb.getExcerpt() != null) {
            method.addParameter(TRACKBACK_EXCERPT_PARAM, tb.getExcerpt());
        }
        Map headers = this.buildHttpHeaders(trackbackPingURL, tb);
        Iterator iterator = headers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            method.addRequestHeader((String)entry.getKey(), (String)entry.getValue());
        }
        return method;
    }

    static {
        HashMap<String, String> tempMap = new HashMap<String, String>();
        tempMap.put("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
        requestHeaderMap = Collections.unmodifiableMap(tempMap);
    }
}

