/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.trackback;

import com.atlassian.trackback.TrackbackFinder;
import com.atlassian.trackback.TrackbackUtils;
import java.io.IOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultTrackbackFinder
implements TrackbackFinder {
    private Log log = LogFactory.getLog((Class)DefaultTrackbackFinder.class);

    public List findPingUrls(String content) {
        List urls = this.findPingUrls(TrackbackUtils.getHttpLinks(content));
        return this.filterPingUrls(urls);
    }

    protected List filterPingUrls(List urls) {
        return urls;
    }

    public List findPingUrls(Collection urlLinks) {
        ArrayList<String> result = new ArrayList<String>();
        Iterator iterator = urlLinks.iterator();
        while (iterator.hasNext()) {
            String hyperlink = (String)iterator.next();
            String remoteContent = null;
            try {
                remoteContent = TrackbackUtils.getUrlContent(hyperlink);
            }
            catch (ConnectException ce) {
                this.log.info((Object)("Unable to connect to '" + hyperlink + "': " + ce), (Throwable)ce);
            }
            catch (UnknownHostException uhe) {
                this.log.debug((Object)("Cannot reach host on URL '" + hyperlink + "': " + uhe), (Throwable)uhe);
            }
            catch (IOException e) {
                this.log.info((Object)("Error getting content of URL '" + hyperlink + "': " + e), (Throwable)e);
            }
            catch (RuntimeException re) {
                this.log.error((Object)("Error getting content of " + hyperlink + ": " + re), (Throwable)re);
            }
            if (remoteContent == null) {
                this.log.debug((Object)("No remote content found for url: " + hyperlink));
                continue;
            }
            try {
                String pingUrl = TrackbackUtils.getTrackbackUrl(remoteContent, hyperlink);
                if (pingUrl == null) {
                    this.log.debug((Object)"No trackback URL found in content.");
                    continue;
                }
                result.add(pingUrl);
            }
            catch (RuntimeException re) {
                this.log.info((Object)"Error parsing text for trackback pings", (Throwable)re);
            }
        }
        return result;
    }
}

