package com.atlassian.trackback;

import java.io.IOException;
import java.util.Map;

public interface TrackbackSender
{
    void sendPing(String pingUrl, Trackback tb) throws IOException;

    /**
     * This is called to build that HTTP request headers for the the track back ping request.  For example
     * you could add the "ContentType" header to the HTTP request.
     * <p/>
     * It must be a Map of String keys and values and MUST not be null
     *
     * @param pingUrl the trackback URL in play
     * @param tb      the {@link Trackback} in play
     * @return a Map of HTTP request header values
     */
    Map buildHttpHeaders(String pingUrl, Trackback tb);
}
