package com.atlassian.theme.internal;

import com.atlassian.annotations.nullability.ReturnValuesAreNonnullByDefault;
import com.atlassian.theme.api.Theme;
import com.atlassian.theme.api.ThemeColorMode;
import com.atlassian.theme.internal.api.ThemeService;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.List;
import java.util.Optional;

import static com.atlassian.theme.internal.DefaultThemes.DARK;
import static com.atlassian.theme.internal.DefaultThemes.LIGHT;
import static com.atlassian.theme.internal.DefaultThemes.ORIGINAL;
import static java.util.Arrays.asList;
import static java.util.Objects.isNull;
import static java.util.Objects.requireNonNull;
import static java.util.Optional.empty;

@SuppressWarnings("unused")
@ReturnValuesAreNonnullByDefault
public class DefaultThemeService implements ThemeService {
    @Override
    public List<Theme> getAllAvailableThemes() {
        return asList(DARK, LIGHT, ORIGINAL);
    }

    @Override
    public Optional<Theme> findMatchingTheme(@Nonnull ThemeColorMode themeColorMode, @Nullable String themeKey) {
        requireNonNull(themeColorMode, "themeColorMode");
        if (isNull(themeKey)) {
            return empty();
        }
        return this.getAllAvailableThemes().stream()
                .filter(theme -> themeColorMode.equals(theme.getColorMode()))
                .filter(theme -> themeKey.equals(theme.getThemeKey()))
                .findFirst();
    }
}
