package com.atlassian.theme.internal.api.user;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.annotations.nullability.ReturnValuesAreNonnullByDefault;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.theme.api.Theme;

import java.util.Optional;

/**
 * Update and retrieve
 */
@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public interface UserThemeService {
    Optional<PreferredColorMode> getPreferredColorMode(UserKey userKey);

    void setPreferredColorMode(UserKey userKey, PreferredColorMode preferredColorMode);

    /**
     * Get the user's preferred dark theme iff set
     */
    Optional<Theme> getPreferredDarkTheme(UserKey userKey);

    /**
     * @throws IllegalArgumentException if the provided theme is not dark
     */
    void setPreferredDarkTheme(UserKey userKey, Theme theme);

    /**
     * Get the user's preferred light theme iff set
     */
    Optional<Theme> getPreferredLightTheme(UserKey userKey);

    /**
     * @throws IllegalArgumentException if the provided theme is not light
     */
    void setPreferredLightTheme(UserKey userKey, Theme theme);
}
