package com.atlassian.theme.internal.api.user;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.Optional;

import static java.util.Arrays.stream;

/**
 * The color mode preferred by the user.
 * <p>
 * The string values are API to be used as user preferences,
 */
public enum PreferredColorMode {
    LIGHT,
    DARK,
    /**
     * Match the user agent preferences
     */
    MATCHING;

    /**
     * Same as {@link #valueOf(String)} but returns {@link Optional#empty()} instead of throwing an exception
     */
    @Nonnull
    public static Optional<PreferredColorMode> optionalValueOf(@Nullable String value) {
        return stream(values())
                .filter(validMode -> validMode.toString().equals(value))
                .findAny();
    }
}
