package com.atlassian.theme.internal.api.request;

import com.atlassian.annotations.nullability.ReturnValuesAreNonnullByDefault;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.http.HttpServletRequest;

@ReturnValuesAreNonnullByDefault
@ParametersAreNonnullByDefault
public interface RequestScopeThemeOverrideService {
    void setColorModeOverride(HttpServletRequest httpServletRequest, @Nullable String colorMode);

    void setMatchingUserAgentEnabledOverride(HttpServletRequest httpServletRequest, @Nullable Boolean match);

    void setDarkThemeOverride(HttpServletRequest httpServletRequest, @Nullable String themeKey);
    void setLightThemeOverride(HttpServletRequest httpServletRequest, @Nullable String themeKey);
}
