package com.atlassian.theme.api.request;

import com.atlassian.theme.api.Theme;
import com.atlassian.theme.api.ThemeColorMode;

import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;

/**
 * Returning a single {@link ThemeColorMode} cannot be supported because matching the user-agent is supported
 */
public interface RequestScopeThemeService {
    /**
     * The dark {@link Theme} for this request taking into consideration user preferences and any overrides
     */
    @Nonnull
    Theme getPreferredDarkTheme(@Nonnull HttpServletRequest httpServletRequest);

    /**
     * The light {@link Theme} for this request taking into consideration user preferences and any overrides
     */
    @Nonnull
    Theme getPreferredLightTheme(@Nonnull HttpServletRequest httpServletRequest);

    /**
     * Sets the theme and color mode for the page. Probably needs to be done for any custom pages that don't use a
     * product decorator
     * @return [XSS-safe] attribute keys and values, but not the {@code <html>} tag
     */
    @Nonnull
    String getHtmlAttributesForThisRequest(@Nonnull HttpServletRequest httpServletRequest);
}
