package com.atlassian.theme.api;

/**
 * Every theme is either light or a dark, this makes it easier to support multiple themes of the same color mode,
 * e.g. by re-using images.
 * <p>
 * Use {@link #toString()} for serialisation
 */
public enum ThemeColorMode {
    LIGHT("light"),
    DARK("dark");

    private final String mode;

    ThemeColorMode(String mode) {
        this.mode = mode;
    }

    @Override
    public String toString() {
        return mode;
    }
}
