/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tenancy.compatibility;

import com.atlassian.tenancy.api.Tenant;
import com.atlassian.tenancy.api.TenantAccessor;
import com.atlassian.tenancy.api.TenantContext;
import com.atlassian.tenancy.api.TenantUnavailableException;
import com.atlassian.tenancy.api.UnexpectedTenantChangeException;
import com.atlassian.tenancy.compatibility.CompatibilityTenant;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.concurrent.Callable;

public class CompatibilityTenantAccessor
implements TenantAccessor,
TenantContext {
    private static final Tenant TENANT = new CompatibilityTenant();

    @Override
    public Tenant getCurrentTenant() {
        return TENANT;
    }

    @Override
    public Iterable<Tenant> getAvailableTenants() {
        return Collections.singleton(TENANT);
    }

    @Override
    public <T> T asTenant(Tenant tenant, Callable<T> call) throws InvocationTargetException, TenantUnavailableException {
        if (!tenant.equals(TENANT)) {
            throw new UnexpectedTenantChangeException();
        }
        try {
            return call.call();
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }
}

