package com.atlassian.tenancy.api;

import com.atlassian.annotations.ExperimentalApi;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;

/**
 * NOTE:
 * All of this is deprecated. For current tenancy code, see projects like atlassian-tenant-context
 *
 * Service for explicitly interacting with a server's tenants.
 */
@ExperimentalApi
@Deprecated
public interface TenantAccessor {
    /**
     * Retrieve the tenants currently installed on this server. If a tenant is currently in the
     * process of being introduced, this method will block to prevent race conditions with
     * processing of the TenantArrived event.
     *
     * @return the currently installed tenants. May be empty if no tenants are installed.
     */
    @Deprecated
    Iterable<Tenant> getAvailableTenants();

    /**
     * Execute some code as a particular tenant. This should only be necessary in circumstances where the application
     * has not already put a tenant in the current context.
     *
     * If you attempt to use this method to change tenant contexts (i.e. you are in the context of one tenant, and try
     * to execute code as a different tenant) an exception will be thrown
     *
     * @param tenant the tenant to execute the call on behalf of
     * @param call the Callable to execute
     * @param <T> the expected return type of the call
     * @return the return value of the provided Callable.
     * @throws InvocationTargetException an exception was thrown by the provided Callable
     * @throws TenantUnavailableException the operation could not be performed because the tenant is not currently
     *         installed on the server. This may happen because a tenant has been uninstalled since the last call
     *         to {@link #getAvailableTenants()}.
     * @throws UnexpectedTenantChangeException the method was called from the context of an tenant other than
     *         the one provided as a parameter
     */
    @Deprecated
    <T> T asTenant(Tenant tenant, Callable<T> call) throws TenantUnavailableException, InvocationTargetException;
}
