/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tenancy.api.helper;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Iterables;
import com.atlassian.fugue.Option;
import com.atlassian.tenancy.api.Tenant;
import com.atlassian.tenancy.api.TenantAccessor;
import com.atlassian.tenancy.api.TenantUnavailableException;
import com.atlassian.tenancy.api.helper.Failure;
import com.google.common.base.Function;
import java.util.Collections;
import java.util.concurrent.Callable;

@ExperimentalApi
public class TenantAccessors {
    private TenantAccessors() {
    }

    public static <T> Iterable<Either<Failure, Option<T>>> forEachTenant(final TenantAccessor tenantAccessor, final Callable<T> callable) {
        return Iterables.flatMap(tenantAccessor.getAvailableTenants(), (Function)new Function<Tenant, Iterable<Either<Failure, Option<T>>>>(){

            public Iterable<Either<Failure, Option<T>>> apply(Tenant tenant) {
                try {
                    Object result = tenantAccessor.asTenant(tenant, callable);
                    return Collections.singleton(Either.right((Object)(result != null ? Option.some(result) : Option.none())));
                }
                catch (TenantUnavailableException e) {
                    return Collections.emptyList();
                }
                catch (Exception e) {
                    return Collections.singleton(Either.left((Object)new Failure(tenant, e)));
                }
            }
        });
    }

    public static Iterable<Failure> forEachTenant(TenantAccessor tenantAccessor, final Runnable runnable) {
        return Iterables.flatMap(TenantAccessors.forEachTenant(tenantAccessor, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                runnable.run();
                return null;
            }
        }), (Function)new Function<Either<Failure, Option<Void>>, Iterable<Failure>>(){

            public Iterable<Failure> apply(Either<Failure, Option<Void>> input) {
                return input.left();
            }
        });
    }
}

