/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.velocity.allowlist.uberspect;

import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.velocity.allowlist.api.internal.PluginAllowlist;
import io.atlassian.util.concurrent.Lazy;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.Log;
import org.apache.velocity.util.introspection.SecureIntrospectorImpl;

public class PluginAwareSecureIntrospector
extends SecureIntrospectorImpl {
    public static final String ALLOWLIST_DEBUG_PROPERTY = "atlassian.velocity.method.allowlist.debug";
    public static final String ALLOWLIST_DEBUG_PROPERTY_ALT = "atlassian.plugins.velocity.method.allowlist.debug";
    public static final String ALLOWLIST_EXTRA_PROPERTY = "atlassian.velocity.method.allowlist.extra";
    public static final String ALLOWLIST_EXTRA_PROPERTY_ALT = "atlassian.plugin.velocity.method.allowlist.extra";
    private final boolean allowlistDebugMode = Boolean.getBoolean("atlassian.velocity.method.allowlist.debug") || Boolean.getBoolean("atlassian.plugins.velocity.method.allowlist.debug");
    private final Supplier<Map<Class<?>, Set<String>>> sysPropAllowlistedMethodsRef;
    private PluginAllowlist pluginAllowlist;
    private volatile ClassLoader pluginClassLoader;
    private final AtomicBoolean isPluginFrameworkStarted = new AtomicBoolean();

    public PluginAwareSecureIntrospector(Log log, RuntimeServices runtimeServices) {
        super(log, runtimeServices);
        this.sysPropAllowlistedMethodsRef = this.initSysPropAllowlistedMethods();
    }

    private Supplier<Map<Class<?>, Set<String>>> initSysPropAllowlistedMethods() {
        String allowlistExtra = System.getProperty(ALLOWLIST_EXTRA_PROPERTY, "");
        String allowlistExtraAlt = System.getProperty(ALLOWLIST_EXTRA_PROPERTY_ALT, "");
        String allowlistExtraFinal = allowlistExtra + (!allowlistExtraAlt.isBlank() ? "," : "") + allowlistExtraAlt;
        String[] methodArray = !allowlistExtraFinal.isBlank() ? allowlistExtraFinal.replace("\\", "").split(",") : new String[]{};
        return Lazy.supplier(() -> this.toMethodSet(methodArray));
    }

    public void setPluginAllowlist(PluginAllowlist pluginAllowlist) {
        this.pluginAllowlist = pluginAllowlist;
    }

    protected Class<?> loadClass(String name) throws ClassNotFoundException {
        try {
            return super.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            if (this.pluginClassLoader != null) {
                return this.pluginClassLoader.loadClass(name);
            }
            throw e;
        }
    }

    @EventListener
    public void onPluginFrameworkStarted(PluginFrameworkStartedEvent event) {
        this.pluginClassLoader = event.getPluginAccessor().getClassLoader();
        this.isPluginFrameworkStarted.set(true);
    }

    protected boolean isIntrospectorEnabled() {
        return this.isPluginFrameworkStarted.get();
    }

    protected boolean isAllowlistDebugMode() {
        return super.isAllowlistDebugMode() || this.allowlistDebugMode;
    }

    protected boolean isAllowlistedClassPackageCached(Class<?> clazz) {
        return super.isAllowlistedClassPackageCached(clazz) || this.pluginAllowlist != null && this.pluginAllowlist.isAllowlistedClassPackage(clazz);
    }

    protected boolean isAllowlistedMethodCached(Method method) {
        return super.isAllowlistedMethodCached(method) || this.pluginAllowlist != null && this.pluginAllowlist.isAllowlistedMethod(method);
    }

    protected boolean isAllowlistedMethodInternal(Method method) {
        return super.isAllowlistedMethodInternal(method) || this.isAllowlistedBySysProp(method);
    }

    private boolean isAllowlistedBySysProp(Method method) {
        Set<String> methodAllowlist = this.sysPropAllowlistedMethodsRef.get().get(method.getDeclaringClass());
        return methodAllowlist != null && methodAllowlist.contains(PluginAwareSecureIntrospector.toMethodStr(method));
    }

    public static String toMethodStr(Method method) {
        return method.getName() + "(" + Arrays.stream(method.getParameterTypes()).map(Class::getName).collect(Collectors.joining(" ")) + ")";
    }
}

