/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.synchrony.proxy.web;

import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SynchronyServletConfig
implements ServletConfig {
    private final FilterConfig filterConfig;
    private Set<String> initParameterNames;
    private Map<String, String> initParameters;

    public SynchronyServletConfig(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
        this.initParameterNames = new HashSet(10);
        this.initParameters = new HashMap(10);
        Enumeration originalParameterNames = filterConfig.getInitParameterNames();
        while (originalParameterNames.hasMoreElements()) {
            String parameterName = (String)originalParameterNames.nextElement();
            this.initParameterNames.add(parameterName);
            this.initParameters.put(parameterName, this.getInitParameter(parameterName));
        }
    }

    public String getServletName() {
        return this.filterConfig.getFilterName();
    }

    public ServletContext getServletContext() {
        return this.filterConfig.getServletContext();
    }

    public String getInitParameter(String name) {
        return (String)this.initParameters.get(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return Collections.enumeration(this.initParameterNames);
    }

    public void setInitParameter(String name, String value) {
        if (value != null) {
            this.initParameterNames.add(name);
            this.initParameters.put(name, value);
        }
    }
}

