/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.synchrony.proxy.web;

import com.atlassian.synchrony.proxy.util.SynchronyConfigInfo;
import java.util.Collections;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.proxy.ProxyServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.web.util.UriComponentsBuilder;

public class SynchronyProxyServlet
extends ProxyServlet {
    private static final Logger log = LoggerFactory.getLogger(SynchronyProxyServlet.class);
    private static Set<String> HEADER_BLACKLIST = Collections.singleton("set-cookie");

    protected void copyRequestHeaders(HttpServletRequest clientRequest, Request proxyRequest) {
        if (Boolean.getBoolean("synchrony.enable.xhr.fallback")) {
            proxyRequest.version(HttpVersion.HTTP_1_0);
        }
        super.copyRequestHeaders(clientRequest, proxyRequest);
    }

    protected String filterServerResponseHeader(HttpServletRequest clientRequest, Response serverResponse, String headerName, String headerValue) {
        if (HEADER_BLACKLIST.contains(headerName.toLowerCase())) {
            return "";
        }
        return super.filterServerResponseHeader(clientRequest, serverResponse, headerName, headerValue);
    }

    protected String rewriteTarget(HttpServletRequest request) {
        SynchronyConfigInfo synchronyConfigInfo = SynchronyConfigInfo.fromSystemProperties();
        return UriComponentsBuilder.fromHttpRequest((HttpRequest)new ServletServerHttpRequest(request)).scheme("http").host(synchronyConfigInfo.getSynchronyHost()).port(synchronyConfigInfo.getSynchronyPort().intValue()).replacePath(synchronyConfigInfo.getSynchronyContextPath() + StringUtils.defaultString((String)request.getServletPath())).build().toUriString();
    }

    protected void sendProxyResponseError(HttpServletRequest clientRequest, HttpServletResponse proxyResponse, int status) {
        log.debug("Request {} has received error {}, ignoring proxy response error on response object {}", new Object[]{clientRequest, status, proxyResponse});
    }
}

