/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.synchrony.proxy.web;

import com.atlassian.synchrony.proxy.util.SynchronyProxyPropertiesHelper;
import com.atlassian.synchrony.proxy.util.SynchronyProxyUtils;
import com.atlassian.synchrony.proxy.web.SynchronyProxyServlet;
import com.atlassian.synchrony.proxy.web.SynchronyServletConfig;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="synchronyProxyFilter")
public class SynchronyProxyFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(SynchronyProxyFilter.class);
    private SynchronyProxyServlet proxyServlet;
    private FilterConfig filterConfig;
    private SynchronyServletConfig synchronyServletConfig;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        this.synchronyServletConfig = new SynchronyServletConfig(filterConfig);
        this.reload();
    }

    public void reload() throws ServletException {
        if (this.proxyServlet != null) {
            this.proxyServlet.destroy();
        }
        this.proxyServlet = new SynchronyProxyServlet();
        Properties initParams = SynchronyProxyPropertiesHelper.load((ServletContext)this.filterConfig.getServletContext());
        this.synchronyServletConfig.setInitParameter("maxThreads", initParams.getProperty("maxThreads", "256"));
        this.synchronyServletConfig.setInitParameter("maxConnections", initParams.getProperty("maxConnections", "32768"));
        this.synchronyServletConfig.setInitParameter("idleTimeout", initParams.getProperty("idleTimeout", "30000"));
        this.synchronyServletConfig.setInitParameter("requestBufferSize", initParams.getProperty("requestBufferSize", "16384"));
        this.synchronyServletConfig.setInitParameter("responseBufferSize", initParams.getProperty("responseBufferSize", "16384"));
        this.synchronyServletConfig.setInitParameter("useForwardedHeaders", initParams.getProperty("useForwardedHeaders", "false"));
        this.proxyServlet.init((ServletConfig)this.synchronyServletConfig);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            if (SynchronyProxyUtils.shouldPassThrough((HttpServletRequest)((HttpServletRequest)request))) {
                this.proxyServlet.service(request, response);
                return;
            }
            chain.doFilter(request, response);
        }
        catch (IllegalArgumentException e) {
            log.error("There was an error passing the request to synchrony", (Throwable)e);
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.sendError(400);
        }
    }

    public void destroy() {
        this.proxyServlet.destroy();
    }
}

