/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.synchrony.proxy.websocket;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

public class WebSocketUpstreamHandler
extends TextWebSocketHandler {
    private static final Logger log = LoggerFactory.getLogger(WebSocketUpstreamHandler.class);
    private static final long HANDSHAKE_TIMEOUT = Long.getLong("atlassian.synchrony.proxy.handshake.timeout.sec", 30L);
    private WebSocketSession localSession;
    private CompletableFuture<WebSocketSession> synchronySession = new CompletableFuture();

    public WebSocketUpstreamHandler(WebSocketSession session) {
        this.localSession = session;
    }

    protected void handleTextMessage(WebSocketSession session, TextMessage message) throws Exception {
        log.trace("<<< text message limit: {}", (Object)this.localSession.getTextMessageSizeLimit());
        log.trace("<<< message payload length: {}", (Object)message.getPayloadLength());
        log.trace("<<< message isLast: {}", (Object)message.isLast());
        log.trace("================================================================");
        try {
            this.localSession.sendMessage((WebSocketMessage)message);
        }
        catch (Exception e) {
            log.error("Close the local session and then the remote session due to: {}", (Object)e.getMessage());
            log.debug("", (Throwable)e);
            this.tryCloseLocalSession();
            try {
                session.close();
            }
            catch (IOException e2) {
                log.error("Error closing session in handleTextMessage: {}", (Object)e2.getMessage());
                log.debug("", (Throwable)e);
            }
        }
    }

    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        this.synchronySession.complete(session);
    }

    WebSocketSession getSynchronySession() throws InterruptedException, ExecutionException, TimeoutException {
        return (WebSocketSession)this.synchronySession.get(HANDSHAKE_TIMEOUT, TimeUnit.SECONDS);
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus status) throws Exception {
        log.trace("upstream connection closed. Reason ==> {}", (Object)status.getReason());
        this.tryCloseLocalSession();
        try {
            session.close();
        }
        catch (IOException e2) {
            log.error("Error closing session upstream:", (Throwable)e2);
        }
    }

    public boolean supportsPartialMessages() {
        return true;
    }

    private void tryCloseLocalSession() throws IOException {
        try {
            if (this.localSession != null && this.localSession.isOpen()) {
                log.debug("Attempt to close the localSession downstream");
                this.localSession.close();
            }
        }
        catch (IOException e) {
            log.error("Error occurred while closing downstream: {}", (Object)e.getMessage());
            log.debug("", (Throwable)e);
        }
    }
}

