/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.salext.mail;

import com.atlassian.support.tools.salext.SupportApplicationInfo;
import com.atlassian.support.tools.salext.mail.SupportRequestAttachment;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.commons.io.IOUtils;

public class SupportRequest
implements Serializable {
    public static final int DEFAULT_PRIORITY = 3;
    private final Map<String, String> headers = new HashMap<String, String>();
    private final List<SupportRequestAttachment> attachments = new ArrayList<SupportRequestAttachment>();
    private String description = "";
    private String subject = "";
    private String toAddress;
    private String fromAddress = "";
    private String body;
    private int priority = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String saveForMail(SupportApplicationInfo info) {
        String version;
        String serverID;
        Properties prop = new Properties();
        prop.setProperty("description", this.description);
        prop.setProperty("contactEmail", this.fromAddress);
        prop.setProperty("subject", this.subject);
        String rawTimezone = System.getProperty("user.timezone");
        TimeZone timeZone = TimeZone.getTimeZone(rawTimezone);
        int offsetMS = timeZone.getRawOffset() + (timeZone.inDaylightTime(new Date()) ? timeZone.getDSTSavings() : 0);
        int offsetHour = offsetMS / 1000 / 60 / 60;
        String timezoneStringInGMT = "GMT" + (offsetHour >= 0 ? "+" : "") + offsetHour;
        prop.setProperty("timeZone", timezoneStringInGMT);
        prop.setProperty("priority", String.valueOf(this.priority));
        String sen = info.getApplicationSEN();
        if (sen != null) {
            prop.setProperty("sen", sen);
        }
        if ((serverID = info.getApplicationServerID()) != null) {
            prop.setProperty("serverID", serverID);
        }
        if ((version = info.getApplicationVersion()) != null) {
            prop.setProperty("version", version);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            prop.store(baos, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((OutputStream)baos);
        }
        return baos.toString();
    }

    public Iterable<Map.Entry<String, String>> getHeaders() {
        return this.headers.entrySet();
    }

    public Iterable<SupportRequestAttachment> getAttachments() {
        return this.attachments;
    }

    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public void addAttachment(SupportRequestAttachment attachment) {
        this.attachments.add(attachment);
    }

    public String getDescription() {
        return this.description;
    }

    public String getFromAddress() {
        return this.fromAddress;
    }

    public String getToAddress() {
        return this.toAddress;
    }

    public String getSubject() {
        return this.subject;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setToAddress(String toAddress) {
        this.toAddress = toAddress;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getBody() {
        return this.body;
    }
}

