/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.salext.mail;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.JiraApplicationContext;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.mail.MailException;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.support.tools.salext.SupportApplicationInfo;
import com.atlassian.support.tools.salext.mail.AbstractMailUtility;
import com.atlassian.support.tools.salext.mail.ProductAwareEmail;
import com.atlassian.support.tools.salext.mail.SimpleSupportMailQueueItem;
import com.atlassian.support.tools.salext.mail.SupportRequest;
import com.atlassian.support.tools.salext.mail.SupportRequestMailQueueItem;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import org.apache.log4j.Logger;

public class JiraMailUtility
extends AbstractMailUtility {
    private static final Logger log = Logger.getLogger(JiraMailUtility.class);
    public static final String HEADER_JIRA_FINGER_PRINT = "X-JIRA-FingerPrint";

    @Override
    protected void queueSupportRequestEmail(SupportRequest requestInfo, SupportApplicationInfo info) throws MailException, AddressException, MessagingException {
        JiraApplicationContext context = (JiraApplicationContext)ComponentManager.getComponentInstanceOfType(JiraApplicationContext.class);
        requestInfo.addHeader(HEADER_JIRA_FINGER_PRINT, context.getFingerPrint());
        SupportRequestMailQueueItem item = new SupportRequestMailQueueItem(requestInfo, info);
        ComponentAccessor.getMailQueue().addItem((MailQueueItem)item);
    }

    @Override
    public void sendMail(ProductAwareEmail email) {
        SimpleSupportMailQueueItem item = new SimpleSupportMailQueueItem(email);
        if (this.isMailServerConfigured()) {
            ComponentAccessor.getMailQueue().addItem((MailQueueItem)item);
            log.debug((Object)("Added message'" + item.getSubject() + "' to JIRA's mail queue..."));
        } else {
            try {
                item.send();
                log.debug((Object)("Sent message'" + item.getSubject() + "' using Atlassian's mail servers..."));
            }
            catch (MailException e) {
                log.error((Object)"Exception sending email using Atlassian's mail servers:", (Throwable)e);
            }
        }
    }
}

