/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.salext.bundle;

import com.atlassian.support.tools.ValidationLog;
import com.atlassian.support.tools.salext.bundle.AbstractApplicationFileBundle;
import com.atlassian.support.tools.salext.bundle.BundleManifest;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ListApplicationFileBundle
extends AbstractApplicationFileBundle {
    private final Map<String, String> files = new HashMap<String, String>();
    private static final Logger log = Logger.getLogger(ListApplicationFileBundle.class);

    public ListApplicationFileBundle(BundleManifest bundle, String title, String description, String baseDirectory, List<String> files) {
        super(bundle, title, description);
        for (String file : files) {
            this.files.put(file, "");
        }
    }

    @Override
    public Map<String, String> getFiles() {
        return this.files;
    }

    @Override
    public void validate(ValidationLog validationLog) {
        for (String filename : this.files.keySet()) {
            File file = new File(filename);
            if (file.length() != 0L) continue;
            log.warn((Object)("The file " + file.getAbsolutePath() + " does not contain any data, and was skipped."));
        }
    }
}

