/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.salext;

import com.atlassian.extras.api.ProductLicense;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sisyphus.SisyphusPatternSource;
import com.atlassian.sisyphus.SisyphusPatternSourceDecorator;
import com.atlassian.stash.license.LicenseService;
import com.atlassian.support.tools.hercules.ScanItem;
import com.atlassian.support.tools.properties.SupportInfoAppenderManager;
import com.atlassian.support.tools.properties.SupportInfoXmlKeyResolver;
import com.atlassian.support.tools.salext.AbstractSupportApplicationInfo;
import com.atlassian.support.tools.salext.bundle.BundleManifest;
import com.atlassian.support.tools.salext.bundle.DefaultApplicationFileBundle;
import com.atlassian.support.tools.salext.bundle.WildcardApplicationFileBundle;
import com.atlassian.support.tools.salext.license.ApplicationLicenseInfo;
import com.atlassian.support.tools.salext.license.ProductLicenseInfo;
import com.atlassian.support.tools.zip.FileSanitizer;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;

public class StashApplicationInfo
extends AbstractSupportApplicationInfo {
    private static final String ZIP_INCLUDE_STASH_LOGS_DESCRIPTION = "stp.zip.include.stash.logs.description";
    private static final String ZIP_INCLUDE_STASH_LOGS = "stp.zip.include.stash.logs";
    private static final String ZIP_INCLUDE_STASH_CFG_DESCRIPTION = "stp.zip.include.stash.cfg.description";
    private static final String ZIP_INCLUDE_STASH_CFG = "stp.zip.include.stash.cfg";
    public static final String LOG_FILE_REGEX = "(^(?!.*audit).*\\.log.*)";
    private final LicenseHandler licenseHandler;
    private final LicenseService licenseService;

    public StashApplicationInfo(ApplicationProperties applicationProperties, I18nResolver i18nResolver, UserManager userManager, TemplateRenderer renderer, LicenseHandler licenseHandler, LicenseService licenseService, SupportInfoAppenderManager supportInfoAppenderManager, SupportInfoXmlKeyResolver supportInfoXmlKeyResolver) {
        super(applicationProperties, i18nResolver, userManager, renderer, supportInfoAppenderManager, supportInfoXmlKeyResolver);
        this.licenseHandler = licenseHandler;
        this.licenseService = licenseService;
    }

    @Override
    public List<ScanItem> getApplicationLogFilePaths() {
        String logFilePath = this.applicationProperties.getHomeDirectory() + "/log/atlassian-stash.log";
        if (new File(logFilePath).exists()) {
            return Collections.singletonList(ScanItem.createDefaultItem(logFilePath));
        }
        return Collections.emptyList();
    }

    @Override
    public SisyphusPatternSource getPatternSource() throws IOException, ClassNotFoundException {
        SisyphusPatternSourceDecorator source = new SisyphusPatternSourceDecorator();
        source.add(this.getPatternSourceByURL("https://confluence.atlassian.com/download/attachments/179443532/stash_regex.xml", this.getProxy()));
        return source;
    }

    @Override
    public String getApplicationSEN() {
        return this.licenseHandler.getSupportEntitlementNumber();
    }

    @Override
    public String getApplicationServerID() {
        return this.licenseHandler.getServerId();
    }

    @Override
    public String getCreateSupportRequestEmail() {
        return "stash-autosupportrequests@atlassian.com";
    }

    @Override
    public String getMailQueueURL(HttpServletRequest request) {
        return null;
    }

    @Override
    public boolean isMailExceptionAvailable() {
        return false;
    }

    @Override
    public String getMailServerConfigurationURL(HttpServletRequest request) {
        return this.getBaseURL(request) + "/admin/mail-server";
    }

    @Override
    public FileSanitizer getFileSanitizer() {
        return new FileSanitizer(FILE_PATTERNS);
    }

    @Override
    public void initServletInfo(ServletConfig config) {
        super.initServletInfo(config);
        this.applicationInfoBundles.add(new DefaultApplicationFileBundle(BundleManifest.APPLICATION_CONFIG, ZIP_INCLUDE_STASH_CFG, ZIP_INCLUDE_STASH_CFG_DESCRIPTION, this.getApplicationHome() + "/stash-config.properties"));
        this.applicationInfoBundles.add(new WildcardApplicationFileBundle(BundleManifest.TOMCAT_CONFIG, "stp.zip.include.tomcat.conf", "stp.zip.include.tomcat.conf.description", this.findTomcatFileOrDirectory("conf"), "^.*\\.(xml|properties|policy)$"));
        this.applicationInfoBundles.add(new DefaultApplicationFileBundle(BundleManifest.CACHE_CONFIG, "stp.zip.include.cache.cfg", "stp.zip.include.cache.cfg.description", new String[0]));
        this.applicationInfoBundles.add(new WildcardApplicationFileBundle(BundleManifest.APPLICATION_LOGS, ZIP_INCLUDE_STASH_LOGS, ZIP_INCLUDE_STASH_LOGS_DESCRIPTION, this.getApplicationHome() + "/log", LOG_FILE_REGEX));
        this.applicationInfoBundles.add(new WildcardApplicationFileBundle(BundleManifest.TOMCAT_LOGS, "stp.zip.include.tomcat.logs", "stp.zip.include.tomcat.logs.description", this.findTomcatFileOrDirectory("logs"), "^.*\\.(log|out)$"));
    }

    @Override
    public String getApplicationLogDir() {
        return this.getApplicationHome() + "/log";
    }

    @Override
    public ApplicationLicenseInfo getLicenseInfo() {
        return new ProductLicenseInfo((ProductLicense)this.licenseService.get());
    }

    static {
        FILE_PATTERNS.put("stash-config.properties", Arrays.asList(Pattern.compile("^[#\\s]*jdbc\\.password\\s*.(.*)", 2)));
    }
}

