/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.properties.appenders;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.support.tools.spi.RootLevelSupportInfoAppender;
import com.atlassian.support.tools.spi.SupportInfoBuilder;

public class ApplicationLinksInfoAppender
extends RootLevelSupportInfoAppender {
    private final ApplicationLinkService linkService;

    public ApplicationLinksInfoAppender(ApplicationLinkService linkService) {
        this.linkService = linkService;
    }

    @Override
    protected void addSupportInfo(SupportInfoBuilder builder) {
        this.addApplicationLinkInformation(builder.addCategory("stp.properties.links"));
    }

    private void addApplicationLinkInformation(SupportInfoBuilder builder) {
        for (ApplicationLink link : this.linkService.getApplicationLinks()) {
            SupportInfoBuilder linkBuilder = builder.addCategory("stp.properties.links");
            linkBuilder.addValue("stp.properties.links.name", link.getName());
            linkBuilder.addValue("stp.properties.links.primary", String.valueOf(link.isPrimary()));
            linkBuilder.addValue("stp.properties.links.type", link.getType().getI18nKey());
            linkBuilder.addValue("stp.properties.links.display.url", link.getDisplayUrl().toString());
            linkBuilder.addValue("stp.properties.links.rpc.url", link.getRpcUrl().toString());
            linkBuilder.addContext(link);
        }
    }
}

