/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.properties;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.Resources;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.support.tools.properties.SupportInfoXmlKeyResolver;
import com.atlassian.util.concurrent.CopyOnWriteMap;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class PluginSupportInfoXmlKeyResolver
implements SupportInfoXmlKeyResolver {
    private static final String SUPPORT_INFO_XML = "support-info-xml";
    private static final Logger log = Logger.getLogger(PluginSupportInfoXmlKeyResolver.class);
    private final Map<Plugin, Iterable<String>> xmlNamesResources = CopyOnWriteMap.builder().newHashMap();

    public PluginSupportInfoXmlKeyResolver(PluginAccessor pluginAccessor, PluginEventManager pluginEventManager) {
        pluginEventManager.register((Object)this);
        this.resolveResources(pluginAccessor.getEnabledPlugins());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getKeyMappings() {
        Properties xmlNames = new Properties();
        for (Map.Entry<Plugin, Iterable<String>> pluginResources : this.xmlNamesResources.entrySet()) {
            for (String resource : pluginResources.getValue()) {
                InputStream stream = pluginResources.getKey().getClassLoader().getResourceAsStream(resource);
                if (stream == null) {
                    log.error((Object)"Error loading xml elements from resource file.");
                    continue;
                }
                try {
                    xmlNames.load(stream);
                }
                catch (IOException e) {
                    log.error((Object)"Error loading xml element names for use in application property files:", (Throwable)e);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)stream);
                }
            }
        }
        return xmlNames;
    }

    @PluginEventListener
    public void onPluginDisabled(PluginDisabledEvent event) {
        this.xmlNamesResources.remove(event.getPlugin());
    }

    @PluginEventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        Plugin plugin = event.getPlugin();
        this.resolveResources(Collections.singleton(plugin));
    }

    private void resolveResources(Collection<Plugin> plugins) {
        for (Plugin plugin : plugins) {
            Collection descriptors = Collections2.filter((Collection)plugin.getResourceDescriptors(), (Predicate)new Resources.TypeFilter(SUPPORT_INFO_XML));
            if (descriptors.isEmpty()) continue;
            ImmutableSet locations = ImmutableSet.copyOf((Iterable)Collections2.transform((Collection)descriptors, (Function)new Function<ResourceDescriptor, String>(){

                public String apply(ResourceDescriptor descriptor) {
                    return descriptor.getLocation();
                }
            }));
            this.xmlNamesResources.put(plugin, (Iterable<String>)locations);
        }
    }
}

