/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.action.impl;

import com.atlassian.support.tools.action.SupportActionFactory;
import com.atlassian.support.tools.action.SupportToolsAction;
import com.atlassian.support.tools.action.impl.HomeAction;
import com.atlassian.support.tools.action.impl.SystemInfoAction;
import com.atlassian.support.tools.action.impl.TabsAction;
import com.atlassian.support.tools.hercules.SupportToolsHerculesScanAction;
import com.atlassian.support.tools.hercules.SupportToolsHerculesScanPercentageAction;
import com.atlassian.support.tools.request.CreateSupportRequestAction;
import com.atlassian.support.tools.salext.SupportApplicationInfo;
import com.atlassian.support.tools.salext.mail.MailUtility;
import com.atlassian.support.tools.scheduler.ScheduledHealthReportAction;
import com.atlassian.support.tools.scheduler.ScheduledHerculesAction;
import com.atlassian.support.tools.scheduler.SupportScheduledTaskController;
import com.atlassian.support.tools.zip.SupportZipAction;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class DefaultSupportActionFactory
implements SupportActionFactory {
    private final Map<String, SupportToolsAction> ACTIONS = new TreeMap<String, SupportToolsAction>();
    private final Map<String, List<SupportToolsAction>> actionsByCategory = new LinkedHashMap<String, List<SupportToolsAction>>();

    public DefaultSupportActionFactory(SupportApplicationInfo info, MailUtility mailUtility, SupportScheduledTaskController controller) throws GeneralSecurityException {
        this.addAction(new TabsAction(info));
        this.addAction(new HomeAction(info));
        this.addAction(new CreateSupportRequestAction(info, mailUtility));
        this.addAction(new SupportZipAction(info));
        this.addAction(new SupportToolsHerculesScanPercentageAction(info));
        this.addAction(new SupportToolsHerculesScanAction(info));
        this.addAction(new SystemInfoAction(info));
        this.addAction(new ScheduledHerculesAction(controller, info));
        this.addAction(new ScheduledHealthReportAction(controller, info));
    }

    private void addAction(SupportToolsAction action) {
        this.ACTIONS.put(action.getName(), action);
        if (action.getCategory() != null && action.getTitle() != null) {
            List<SupportToolsAction> actions = this.actionsByCategory.get(action.getCategory());
            if (actions == null) {
                actions = new ArrayList<SupportToolsAction>();
                this.actionsByCategory.put(action.getCategory(), actions);
            }
            actions.add(action);
        }
    }

    @Override
    public SupportToolsAction getAction(String name) {
        SupportToolsAction action;
        if (name == null) {
            name = "tabs";
        }
        if ((action = this.ACTIONS.get(name)) != null) {
            return action.newInstance();
        }
        return this.ACTIONS.get("tabs").newInstance();
    }

    @Override
    public List<String> getActionCategories() {
        return new ArrayList<String>(this.actionsByCategory.keySet());
    }

    @Override
    public List<SupportToolsAction> getActionsByCategory(String category) {
        return this.actionsByCategory.get(category);
    }

    @Override
    public List<SupportToolsAction> getActions() {
        return (List)this.ACTIONS.values();
    }
}

