(function($) {
    var LicenseStatus =
    {
        destroyBanner: function()
        {
            AJS.$("#stp-licenseStatus-banner").slideUp(function()
            {
                AJS.$("#stp-licenseStatus-banner")  .remove();
            });
        },
        
        remindMeNever: function(e)
        {
        	e.preventDefault();
            AJS.$.ajax(
            {
                type: "POST",
                async: true,
                url: AJS.contextPath() + "/rest/stp/1.0/license/remindMeNever"
            });
        	LicenseStatus.destroyBanner();
        }, 
        
        remindMeLater: function()
        {
            AJS.$.ajax(
	        {
	            type: "POST",
	            async: true,
	            url: AJS.contextPath() + "/rest/stp/1.0/license/remindMeLater"
	        });
            LicenseStatus.destroyBanner();
        },

        recordOutboundLink: function(account, campaign)
        {
            var _gaq = _gaq || [];
            _gaq.push(
                ['_setAccount', account],
                ['_setCampSourceKey', 'STP'],
                ['_setCampMediumKey', 'renewals_reminder'],
                ['_setCampNameKey', campaign],
                ['_trackEvent', 'renewal']
            );
        },

        createBanner: function()
        {
            AJS.$.ajax(
            {
                type: "GET",
                dataType: "json",
                async: true,
                url: AJS.contextPath() + "/rest/stp/1.0/license/status",
                statusCode:
                {
                    200: function(data)
                    {
                    	var banner = "\n<div id='stp-licenseStatus-banner'>\n";
                        var daysToExpiry = data.daysToExpiry;
                        var contactAtlassian = "http://www.atlassian.com/company/contact?utm_source=STP&utm_medium=renewals_reminder&utm_campaign=";
                        var myAtlassian = "http://www.my.atlassian.com?utm_source=STP&utm_medium=renewals_reminder&utm_campaign=";

                        if(daysToExpiry <= 30 && daysToExpiry > 14)
                        {
                            licenseLink = contactAtlassian + "renewals_30_reminder";
                            banner += AJS.I18n.getText('stp.license.banner.expires30days', data.productName, 30, '<a id=\'stp-licenseStatus-contactAtlassian\' target=\'_blank\' href="'+licenseLink+'">', '</a>', '<a id=\'stp-licenseStatus-remindMeLater\' href=\'#\'>', '</a>');
                            banner += "\n<button id='stp-licenseStatus-remindMeNever'>&#x2716;</button>";
                        }
                        else if(daysToExpiry <=14 && daysToExpiry > 7)
                        {
                            licenseLink = contactAtlassian + "renewals_14_reminder";
                            banner += AJS.I18n.getText('stp.license.banner.expires14days', data.productName, 14, '<a id=\'stp-licenseStatus-contactAtlassian\' target=\'_blank\' href="'+licenseLink+'">', '</a>', '<a id=\'stp-licenseStatus-remindMeLater\' href=\'#\'>', '</a>');
                        }
                        else if(daysToExpiry <= 7)
                        {
                            licenseLink = myAtlassian + "renewals_7_reminder";
                            banner += AJS.I18n.getText('stp.license.banner.expires7days', data.productName, 7, '<a id=\'stp-licenseStatus-renewNow\' target=\'_blank\' href="'+licenseLink+'">', '</a>');
                            banner += "\n<button id='stp-licenseStatus-remindMeNever'>&#x2716;</button>";
                        }

                    	banner += "\n</div>";
                        $(banner).prependTo(document.body);
                        AJS.$("#stp-licenseStatus-remindMeNever").click(LicenseStatus.remindMeNever);

                        AJS.$("#stp-licenseStatus-remindMeLater").click(function(e)
                		{
                        	e.preventDefault();
                        	LicenseStatus.remindMeLater();
                		});

                        AJS.$("#stp-licenseStatus-contactAtlassian").click(function(e)
                		{
                            LicenseStatus.remindMeLater();
                		});

                        AJS.$("#stp-licenseStatus-renewNow").click(function(e)
                        {
                            LicenseStatus.remindMeLater();
                        });
                    }
                }
            });
        }
    };

    AJS.$(document).ready(function()
    {
        $('#stp-licenseStatus-banner').length || LicenseStatus.createBanner();
    });
})(AJS.$);
