package com.atlassian.support.tools.salext;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sisyphus.SisyphusPatternSource;
import com.atlassian.sisyphus.SisyphusPatternSourceDecorator;
import com.atlassian.stash.license.LicenseService;
import com.atlassian.support.tools.hercules.ScanItem;
import com.atlassian.support.tools.properties.SupportInfoAppenderManager;
import com.atlassian.support.tools.properties.SupportInfoXmlKeyResolver;
import com.atlassian.support.tools.salext.bundle.BundleManifest;
import com.atlassian.support.tools.salext.bundle.DefaultApplicationFileBundle;
import com.atlassian.support.tools.salext.bundle.WildcardApplicationFileBundle;
import com.atlassian.support.tools.salext.license.ApplicationLicenseInfo;
import com.atlassian.support.tools.salext.license.ProductLicenseInfo;
import com.atlassian.support.tools.zip.FileSanitizer;
import com.atlassian.templaterenderer.TemplateRenderer;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class StashApplicationInfo extends AbstractSupportApplicationInfo
{

    private static final String ZIP_INCLUDE_STASH_LOGS_DESCRIPTION = "stp.zip.include.stash.logs.description";
    private static final String ZIP_INCLUDE_STASH_LOGS = "stp.zip.include.stash.logs";
    private static final String ZIP_INCLUDE_STASH_CFG_DESCRIPTION = "stp.zip.include.stash.cfg.description";
    private static final String ZIP_INCLUDE_STASH_CFG = "stp.zip.include.stash.cfg";

    static
    {
        FILE_PATTERNS.put("stash-config.properties", Arrays.asList(Pattern.compile("^[#\\s]*jdbc\\.password\\s*.(.*)", Pattern.CASE_INSENSITIVE)));
    }

    public static final String LOG_FILE_REGEX = "(^(?!.*audit).*\\.log.*)";

    // TODO:  When all products are at SAL 2.7.0, move this and the methods that use it to the abstract parent
    private final LicenseHandler licenseHandler;
    private final LicenseService licenseService;

    public StashApplicationInfo(ApplicationProperties applicationProperties,
                                I18nResolver i18nResolver,
                                UserManager userManager,
                                TemplateRenderer renderer,
                                LicenseHandler licenseHandler,
                                com.atlassian.stash.license.LicenseService licenseService,
                                SupportInfoAppenderManager supportInfoAppenderManager,
                                SupportInfoXmlKeyResolver supportInfoXmlKeyResolver)
    {
        super(applicationProperties, i18nResolver, userManager, renderer, supportInfoAppenderManager, supportInfoXmlKeyResolver);
        this.licenseHandler = licenseHandler;
        this.licenseService = licenseService;
    }

    @Override
    public List<ScanItem> getApplicationLogFilePaths()
    {
        String logFilePath = applicationProperties.getHomeDirectory() + "/log/atlassian-stash.log";

        if (new File(logFilePath).exists())
        {
            return Collections.singletonList(ScanItem.createDefaultItem(logFilePath));
        }

        return Collections.emptyList();
    }

    @Override
    public SisyphusPatternSource getPatternSource() throws IOException, ClassNotFoundException
    {
        SisyphusPatternSourceDecorator source = new SisyphusPatternSourceDecorator();
        source.add(getPatternSourceByURL("https://confluence.atlassian.com/download/attachments/179443532/stash_regex.xml", getProxy()));
        return source;
    }

    @Override
    public String getApplicationSEN()
    {
        return licenseHandler.getSupportEntitlementNumber();
    }

    @Override
    public String getApplicationServerID()
    {
        return licenseHandler.getServerId();
    }

    @Override
    public String getCreateSupportRequestEmail()
    {
        return "stash-autosupportrequests@atlassian.com";
    }

    @Override
    public String getMailQueueURL(HttpServletRequest request)
    {
        return null;
    }

    @Override
    public boolean isMailExceptionAvailable()
    {
        return false;
    }

    @Override
    public String getMailServerConfigurationURL(HttpServletRequest request)
    {
        return getBaseURL(request) + "/admin/mail-server";
    }

    @Override
    public FileSanitizer getFileSanitizer()
    {
        return new FileSanitizer(FILE_PATTERNS);
    }

    @Override
    public void initServletInfo(ServletConfig config)
    {
        super.initServletInfo(config);
        this.applicationInfoBundles.add(new DefaultApplicationFileBundle(BundleManifest.APPLICATION_CONFIG, ZIP_INCLUDE_STASH_CFG,
                ZIP_INCLUDE_STASH_CFG_DESCRIPTION, getApplicationHome() + "/stash-config.properties"));
        this.applicationInfoBundles.add(new WildcardApplicationFileBundle(BundleManifest.TOMCAT_CONFIG, ZIP_INCLUDE_TOMCAT_CONF,
                ZIP_INCLUDE_TOMCAT_CONF_DESCRIPTION, findTomcatFileOrDirectory("conf"),
                "^.*\\.(xml|properties|policy)$"));
        this.applicationInfoBundles.add(new DefaultApplicationFileBundle(BundleManifest.CACHE_CONFIG, ZIP_INCLUDE_CACHE_CFG,
                ZIP_INCLUDE_CACHE_CFG_DESCRIPTION));
        this.applicationInfoBundles.add(new WildcardApplicationFileBundle(BundleManifest.APPLICATION_LOGS,
                ZIP_INCLUDE_STASH_LOGS, ZIP_INCLUDE_STASH_LOGS_DESCRIPTION,
                getApplicationHome() + "/log", LOG_FILE_REGEX));
        this.applicationInfoBundles.add(new WildcardApplicationFileBundle(BundleManifest.TOMCAT_LOGS, ZIP_INCLUDE_TOMCAT_LOGS,
                ZIP_INCLUDE_TOMCAT_LOGS_DESCRIPTION, findTomcatFileOrDirectory("logs"), "^.*\\.(log|out)$"));
    }

    @Override
    public String getApplicationLogDir()
    {
        return getApplicationHome() + "/log";
    }

    @Override
    public ApplicationLicenseInfo getLicenseInfo()
    {
        return new ProductLicenseInfo(licenseService.get());
    }
}
