package com.atlassian.support.tools.properties.appenders;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.support.tools.spi.RootLevelSupportInfoAppender;
import com.atlassian.support.tools.spi.SupportInfoBuilder;

import static com.atlassian.support.tools.salext.SupportApplicationInfo.*;

/**
 * Adds information about installed plugins.
 */
public class PluginsSupportInfoAppender extends RootLevelSupportInfoAppender
{
    private final PluginAccessor pluginAccessor;

    public PluginsSupportInfoAppender(PluginAccessor pluginAccessor)
    {
        this.pluginAccessor = pluginAccessor;
    }

    @Override
    protected void addSupportInfo(SupportInfoBuilder builder)
    {
        addPluginsInformation(builder.addCategory(PLUGINS));
    }

    private void addPluginsInformation(SupportInfoBuilder builder)
    {
        for (Plugin plugin : pluginAccessor.getPlugins())
        {
            addPluginInformation(builder.addCategory(PLUGINS_PLUGIN), plugin);
        }
    }

    void addPluginInformation(SupportInfoBuilder pluginBuilder, Plugin plugin)
    {
        PluginInformation pluginInformation = plugin.getPluginInformation();
        pluginBuilder.addValue(PLUGIN_KEY, plugin.getKey());
        pluginBuilder.addValue(PLUGIN_VERSION, pluginInformation.getVersion());
        pluginBuilder.addValue(PLUGIN_VENDOR, pluginInformation.getVendorName());
        pluginBuilder.addValue(PLUGIN_STATUS, plugin.getPluginState().toString());
        pluginBuilder.addValue(PLUGIN_VENDOR_URL, pluginInformation.getVendorUrl());
        pluginBuilder.addValue(PLUGIN_FRAMEWORK_VERSION, String.valueOf(plugin.getPluginsVersion()));
        pluginBuilder.addContext(plugin);
    }

}
