package net.admin4j.ui.servlets;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import net.admin4j.config.HackedAdmin4JConfiguration;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Enumeration;

public class AchooHomeDir extends FileExplorerServlet {

    private final ApplicationProperties applicationProperties;
    private final UserManager userManager;


    public AchooHomeDir(ApplicationProperties applicationProperties,
                        UserManager userManager) {
        this.applicationProperties = applicationProperties;
        this.userManager = userManager;
    }

    @Override
    public void init(ServletConfig config) throws ServletException {

        final String home = applicationProperties.getHomeDirectory().getAbsolutePath();
        HackedAdmin4JConfiguration.updateBaseDir(home);

        final ServletConfig homeConfig = new ServletConfig() {
            @Override
            public String getServletName() {
                return config.getServletName();
            }

            @Override
            public ServletContext getServletContext() {
                return config.getServletContext();
            }

            @Override
            public String getInitParameter(String s) {
                return s.contains("base.dir.name")
                        ? null //home
                        : config.getInitParameter(s);
            }

            @Override
            public Enumeration<String> getInitParameterNames() {
                return config.getInitParameterNames();
            }
        };

        super.init(homeConfig);
    }

    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        final UserKey userKey = userManager.getRemoteUserKey(request);

        if (userKey != null && userManager.isSystemAdmin(userKey)) {
            super.service(request, response);
        } else {
            try {
                response.sendError(HttpServletResponse.SC_FORBIDDEN, "Only a system administrator can access this resource");
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}
