package com.atlassian.database.console;

import java.io.IOException;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;

import javax.inject.Inject;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;

import com.atlassian.sal.api.rdbms.TransactionalExecutor;
import com.atlassian.sal.api.rdbms.TransactionalExecutorFactory;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;

import org.h2.server.web.HackedWebServer;
import org.h2.server.web.WebServlet;
import org.h2.util.New;

//TODO: confirm autocommit and transaction isolation level
public class HackedWebServlet extends WebServlet
{
    private final TransactionalExecutorFactory transactionalExecutorFactory;
    private final UserManager userManager;

    HackedWebServer hackedWebServer;
    Connection connection;

    @Inject
    public HackedWebServlet(TransactionalExecutorFactory transactionalExecutorFactory, UserManager userManager)
    {
        this.transactionalExecutorFactory = transactionalExecutorFactory;
        this.userManager = userManager;
    }

    @Override
    public void init()
    {
        final TransactionalExecutor executor = transactionalExecutorFactory.createExecutor();
        executor.readWrite().newTransaction().execute(jdbc -> {
            connection = jdbc;

            //BEGIN: COPY OF SUPER#INIT
            ServletConfig config = getServletConfig();
            Enumeration<?> en = config.getInitParameterNames();
            ArrayList<String> list = New.arrayList();
            while (en.hasMoreElements())
            {
                String name = en.nextElement().toString();
                String value = config.getInitParameter(name);
                if (!name.startsWith("-"))
                {
                    name = "-" + name;
                }
                list.add(name);
                if (value.length() > 0)
                {
                    list.add(value);
                }
            }
            String[] args = new String[list.size()];
            list.toArray(args);
            //END: COPY OF SUPER#INIT

            hackedWebServer = new HackedWebServer(args, this);

            inject(this.getClass().getSuperclass(), this, "server", hackedWebServer);
            return null;
        });
    }

    @Override
    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException
    {
        final UserKey userKey = userManager.getRemoteUserKey(req);

        if (userKey != null && userManager.isSystemAdmin(userKey))
        {

            final TransactionalExecutor executor = transactionalExecutorFactory.createExecutor();
            executor.readWrite().newTransaction().execute(jdbc -> {
                connection = jdbc;

                final String someUrl = getConnectionUrl();

                final HttpServletRequest wrapper = new HttpServletRequestWrapper(req)
                {
                    @Override
                    public Enumeration getParameterNames()
                    {
                        Enumeration e = super.getParameterNames();
                        Vector v = new Vector();
                        while (e.hasMoreElements())
                        {
                            v.add(e.nextElement());
                        }
                        v.add("jsessionid");
                        return v.elements();
                    }

                    @Override
                    public Object getAttribute(String name)
                    {
                        switch (name)
                        {
                            case "url":
                                return someUrl;
                            case "jsessionid":
                                return "jsessionid";
                            default:
                                return super.getAttribute(name);
                        }
                    }

                    @Override
                    public String getParameter(String name)
                    {
                        switch (name)
                        {
                            case "url":
                                return someUrl;
                            case "jsessionid":
                                return "jsessionid";
                            default:
                                return super.getParameter(name);
                        }
                    }
                };

                req.setAttribute("url", someUrl);

                try
                {
                    super.doGet(wrapper, resp);
                }
                catch (IOException e)
                {
                    throw new RuntimeException(e);
                }

                return null;
            });
        }
        else
        {
            try
            {
                resp.sendError(HttpServletResponse.SC_FORBIDDEN, "Only a system administrator can access this resource");
            }
            catch (IOException e)
            {
                throw new RuntimeException(e);
            }
        }
    }

    public Connection getConnection()
    {
        return connection;
    }

    public DatabaseMetaData getConnectionMetaData()
    {
        try
        {
            return connection.getMetaData();
        }
        catch (SQLException e)
        {
            throw new RuntimeException(e);
        }
    }

    public String getConnectionUrl()
    {
        try
        {
            return connection.getMetaData().getURL();
        }
        catch (SQLException e)
        {
            throw new RuntimeException(e);
        }
    }

    public static void inject(Class clazz, Object obj, String fieldName, Object newValue)
    {
        Field fs = null;
        try
        {
            fs = clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e)
        {
            throw new RuntimeException(e);
        }

        fs.setAccessible(true);

        try
        {
            fs.set(obj, newValue);
        }
        catch (IllegalAccessException e)
        {
            throw new RuntimeException(e);
        }
    }
}
