package com.atlassian.xwork.results;

import com.opensymphony.xwork2.ActionInvocation;
import com.rometools.rome.feed.WireFeed;
import com.rometools.rome.feed.synd.SyndFeed;
import com.rometools.rome.io.WireFeedOutput;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.result.StrutsResultSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

public class RssResult extends StrutsResultSupport {
    private static final Logger log = LoggerFactory.getLogger(RssResult.class);
    private static final String DEFAULT_DEFAULT_ENCODING = "UTF-8";

    public static final String RSS = "rss";
    public static final String RSS1 = "rss1";
    public static final String RSS2 = "rss2";
    public static final String ATOM = "atom";

    protected void doExecute(String finalDestination, ActionInvocation actionInvocation) throws Exception {
        // No need to create a session for RSS
        ServletActionContext.getRequest().getSession(false);
        HttpServletResponse response = ServletActionContext.getResponse();

        if (finalDestination.startsWith("rss"))
            response.setContentType("application/rss+xml; charset=" + DEFAULT_DEFAULT_ENCODING);
        else if (finalDestination.startsWith("atom"))
            response.setContentType("application/atom+xml; charset=" + DEFAULT_DEFAULT_ENCODING);
        else
            response.setContentType("text/xml; charset=" + DEFAULT_DEFAULT_ENCODING);

        SyndFeed feed = (SyndFeed) actionInvocation.getStack().findValue("syndFeed");
        if (feed == null)
            throw new ServletException("Unable to find feed for this action");

        WireFeed outFeed = feed.createWireFeed(finalDestination);
        outFeed.setEncoding(DEFAULT_DEFAULT_ENCODING);
        new WireFeedOutput().output(outFeed, response.getWriter());
        try {
            response.flushBuffer();
        } catch (IOException e) {
            log.info("Client aborted (closed the connection) before the rss feed could be returned.");
            if (log.isDebugEnabled()) {
                log.debug("Error sending rss result to client", e);
            }
        }
    }
}
