/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.ser;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.map.introspect.Annotated;
import org.codehaus.jackson.map.introspect.AnnotatedClass;
import org.codehaus.jackson.map.introspect.AnnotatedField;
import org.codehaus.jackson.map.introspect.AnnotatedMethod;
import org.codehaus.jackson.map.introspect.BasicBeanDescription;
import org.codehaus.jackson.map.ser.BasicSerializerFactory;
import org.codehaus.jackson.map.ser.BeanPropertyWriter;
import org.codehaus.jackson.map.ser.BeanSerializer;
import org.codehaus.jackson.map.ser.FilteredBeanPropertyWriter;
import org.codehaus.jackson.map.ser.JsonValueSerializer;
import org.codehaus.jackson.map.ser.PropertyBuilder;
import org.codehaus.jackson.map.util.ArrayBuilders;
import org.codehaus.jackson.map.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanSerializerFactory
extends BasicSerializerFactory {
    public static final BeanSerializerFactory instance = new BeanSerializerFactory();

    protected BeanSerializerFactory() {
    }

    @Override
    public <T> JsonSerializer<T> createSerializer(Class<T> type, SerializationConfig config) {
        BasicBeanDescription beanDesc = (BasicBeanDescription)config.introspect(type);
        JsonSerializer<Object> ser = this.findSerializerFromAnnotation(config, beanDesc.getClassInfo());
        if (ser == null && (ser = super.findSerializerByLookup(type, config)) == null && (ser = super.findSerializerByPrimaryType(type, config)) == null && (ser = this.findBeanSerializer(type, config, beanDesc)) == null) {
            ser = super.findSerializerByAddonType(type, config);
        }
        return ser;
    }

    public JsonSerializer<Object> findBeanSerializer(Class<?> type, SerializationConfig config, BasicBeanDescription beanDesc) {
        if (!this.isPotentialBeanType(type)) {
            return null;
        }
        AnnotatedMethod valueMethod = beanDesc.findJsonValueMethod();
        if (valueMethod != null) {
            JsonSerializer<Object> ser = this.findSerializerFromAnnotation(config, valueMethod);
            return new JsonValueSerializer(valueMethod.getAnnotated(), ser);
        }
        return this.constructBeanSerializer(config, beanDesc);
    }

    protected boolean isPotentialBeanType(Class<?> type) {
        return ClassUtil.canBeABeanType(type) == null && !ClassUtil.isProxyType(type);
    }

    protected JsonSerializer<Object> constructBeanSerializer(SerializationConfig config, BasicBeanDescription beanDesc) {
        List<BeanPropertyWriter> props = this.findBeanProperties(config, beanDesc);
        if (props == null || props.size() == 0) {
            if (beanDesc.hasKnownClassAnnotations()) {
                return BeanSerializer.createDummy(beanDesc.classDescribed());
            }
            return null;
        }
        props = this.filterBeanProperties(config, beanDesc, props);
        props = this.sortBeanProperties(config, beanDesc, props);
        BeanSerializer ser = new BeanSerializer(beanDesc.classDescribed(), props);
        ser = this.processViews(config, beanDesc, ser, props);
        return ser;
    }

    protected List<BeanPropertyWriter> findBeanProperties(SerializationConfig config, BasicBeanDescription beanDesc) {
        BeanPropertyWriter pbw;
        JsonSerializer<Object> annotatedSerializer;
        LinkedHashMap<String, AnnotatedMethod> methodsByProp = beanDesc.findGetters(config.isEnabled(SerializationConfig.Feature.AUTO_DETECT_GETTERS), config.isEnabled(SerializationConfig.Feature.AUTO_DETECT_IS_GETTERS), null);
        LinkedHashMap<String, AnnotatedField> fieldsByProp = beanDesc.findSerializableFields(config.isEnabled(SerializationConfig.Feature.AUTO_DETECT_FIELDS), methodsByProp.keySet());
        if (methodsByProp.isEmpty() && fieldsByProp.isEmpty()) {
            return null;
        }
        boolean fixAccess = config.isEnabled(SerializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS);
        boolean staticTyping = this.usesStaticTyping(config, beanDesc);
        PropertyBuilder pb = this.constructPropertyBuilder(config, beanDesc);
        ArrayList<BeanPropertyWriter> props = new ArrayList<BeanPropertyWriter>(methodsByProp.size());
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        for (Map.Entry<String, AnnotatedField> entry : fieldsByProp.entrySet()) {
            AnnotatedField af = entry.getValue();
            if (fixAccess) {
                af.fixAccess();
            }
            annotatedSerializer = this.findSerializerFromAnnotation(config, af);
            pbw = pb.buildProperty(entry.getKey(), annotatedSerializer, af, staticTyping);
            pbw.setViews(intr.findSerializationViews(af));
            props.add(pbw);
        }
        for (Map.Entry<String, Annotated> entry : methodsByProp.entrySet()) {
            AnnotatedMethod am = (AnnotatedMethod)entry.getValue();
            if (fixAccess) {
                am.fixAccess();
            }
            annotatedSerializer = this.findSerializerFromAnnotation(config, am);
            pbw = pb.buildProperty(entry.getKey(), annotatedSerializer, am, staticTyping);
            pbw.setViews(intr.findSerializationViews(am));
            props.add(pbw);
        }
        return props;
    }

    protected List<BeanPropertyWriter> filterBeanProperties(SerializationConfig config, BasicBeanDescription beanDesc, List<BeanPropertyWriter> props) {
        AnnotatedClass ac;
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        String[] ignored = intr.findPropertiesToIgnore(ac = beanDesc.getClassInfo());
        if (ignored != null && ignored.length > 0) {
            HashSet<String> ignoredSet = ArrayBuilders.arrayToSet(ignored);
            Iterator<BeanPropertyWriter> it = props.iterator();
            while (it.hasNext()) {
                if (!ignoredSet.contains(it.next().getName())) continue;
                it.remove();
            }
        }
        return props;
    }

    protected List<BeanPropertyWriter> sortBeanProperties(SerializationConfig config, BasicBeanDescription beanDesc, List<BeanPropertyWriter> props) {
        boolean sort;
        List<String> creatorProps = beanDesc.findCreatorPropertyNames();
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        AnnotatedClass ac = beanDesc.getClassInfo();
        String[] propOrder = intr.findSerializationPropertyOrder(ac);
        Boolean alpha = intr.findSerializationSortAlphabetically(ac);
        boolean bl = sort = alpha != null && alpha != false;
        if (sort || !creatorProps.isEmpty() || propOrder != null) {
            props = this._sortBeanProperties(props, creatorProps, propOrder, sort);
        }
        return props;
    }

    protected BeanSerializer processViews(SerializationConfig config, BasicBeanDescription beanDesc, BeanSerializer ser, List<BeanPropertyWriter> props) {
        BeanPropertyWriter[] filtered = null;
        int i = 0;
        for (BeanPropertyWriter bpw : props) {
            Class<?>[] views = bpw.getViews();
            if (views != null && views.length > 0) {
                if (filtered == null) {
                    filtered = new BeanPropertyWriter[props.size()];
                }
                filtered[i] = this.constructFilteredBeanWriter(bpw, views);
            }
            ++i;
        }
        if (filtered != null) {
            i = 0;
            for (BeanPropertyWriter bpw : props) {
                if (filtered[i] == null) {
                    filtered[i] = bpw;
                }
                ++i;
            }
            return ser.withFiltered(filtered);
        }
        return ser;
    }

    protected BeanPropertyWriter constructFilteredBeanWriter(BeanPropertyWriter writer, Class<?>[] inViews) {
        return FilteredBeanPropertyWriter.constructViewBased(writer, inViews);
    }

    protected PropertyBuilder constructPropertyBuilder(SerializationConfig config, BasicBeanDescription beanDesc) {
        return new PropertyBuilder(config, beanDesc);
    }

    protected boolean usesStaticTyping(SerializationConfig config, BasicBeanDescription beanDesc) {
        JsonSerialize.Typing t = config.getAnnotationIntrospector().findSerializationTyping(beanDesc.getClassInfo());
        if (t != null) {
            return t == JsonSerialize.Typing.STATIC;
        }
        return config.isEnabled(SerializationConfig.Feature.USE_STATIC_TYPING);
    }

    List<BeanPropertyWriter> _sortBeanProperties(List<BeanPropertyWriter> props, List<String> creatorProps, String[] propertyOrder, boolean sort) {
        int size = props.size();
        AbstractMap all = sort ? new TreeMap() : new LinkedHashMap(size * 2);
        for (BeanPropertyWriter w : props) {
            all.put(w.getName(), w);
        }
        LinkedHashMap<String, BeanPropertyWriter> ordered = new LinkedHashMap<String, BeanPropertyWriter>(size * 2);
        if (propertyOrder != null) {
            for (String name : propertyOrder) {
                BeanPropertyWriter w = (BeanPropertyWriter)all.get(name);
                if (w == null) continue;
                ordered.put(name, w);
            }
        }
        for (String name : creatorProps) {
            BeanPropertyWriter w = (BeanPropertyWriter)all.get(name);
            if (w == null) continue;
            ordered.put(name, w);
        }
        ordered.putAll(all);
        return new ArrayList<BeanPropertyWriter>(ordered.values());
    }
}

