/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.jira.search;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.order.SortOrder;
import com.atlassian.streams.api.ActivityRequest;
import com.atlassian.streams.api.StreamsException;
import com.atlassian.streams.jira.search.Jql;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;

class IssueSearch {
    private final SearchProvider searchProvider;
    private final JiraAuthenticationContext authenticationContext;

    public IssueSearch(SearchProvider searchProvider, JiraAuthenticationContext authenticationContext) {
        this.searchProvider = (SearchProvider)Preconditions.checkNotNull((Object)searchProvider, (Object)"searchProvider");
        this.authenticationContext = (JiraAuthenticationContext)Preconditions.checkNotNull((Object)authenticationContext, (Object)"authenticationContext");
    }

    public Set<Issue> search(ActivityRequest request) {
        Query searchQuery = this.createSearchQuery(request);
        PagerFilter pagerFilter = new PagerFilter(Math.max(10, request.getMaxResults()));
        try {
            SearchResults searchResults = this.searchProvider.search(searchQuery, this.authenticationContext.getLoggedInUser(), pagerFilter);
            return ImmutableSet.copyOf((Collection)searchResults.getIssues());
        }
        catch (SearchException se) {
            throw new StreamsException("Error performing search", (Throwable)se);
        }
    }

    private Query createSearchQuery(ActivityRequest activityRequest) {
        return this.selectIssues(Jql.filterByProject(activityRequest), Jql.filterByUser(activityRequest), Jql.filterByIssueKey(activityRequest), Jql.filterByDate(activityRequest), Jql.filterByIssueType(activityRequest)).orderBy().updatedDate(SortOrder.DESC).buildQuery();
    }

    private JqlQueryBuilder selectIssues(Clause ... clauses) {
        JqlClauseBuilder builder = JqlQueryBuilder.newBuilder().where().defaultAnd();
        for (Clause clause : Iterables.filter(Arrays.asList(clauses), (Predicate)Predicates.notNull())) {
            builder.addClause(clause);
        }
        return builder.endWhere();
    }
}

