/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.jira.renderer;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.bc.project.version.VersionService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.link.RemoteIssueLink;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.issue.worklog.WorklogManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.util.JiraDurationUtils;
import com.atlassian.jira.web.util.OutlookDate;
import com.atlassian.jira.web.util.OutlookDateManager;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.streams.api.Html;
import com.atlassian.streams.api.StreamsEntry;
import com.atlassian.streams.api.UserProfile;
import com.atlassian.streams.api.common.ImmutableNonEmptyList;
import com.atlassian.streams.api.common.Option;
import com.atlassian.streams.api.common.Options;
import com.atlassian.streams.api.renderer.StreamsEntryRendererFactory;
import com.atlassian.streams.jira.AggregatedJiraActivityItem;
import com.atlassian.streams.jira.ChangeItems;
import com.atlassian.streams.jira.JiraActivityItem;
import com.atlassian.streams.jira.JiraHelper;
import com.atlassian.streams.jira.UriProvider;
import com.atlassian.streams.jira.renderer.AttachmentRendererFactory;
import com.atlassian.streams.jira.renderer.IssueActivityObjectRendererFactory;
import com.atlassian.streams.jira.util.RenderingUtilities;
import com.atlassian.streams.spi.renderer.Renderers;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.net.URI;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericValue;

public class IssueUpdateRendererFactory {
    private static final String AFFECTS_VERSION = "version";
    private static final String COMPONENT = "component";
    private static final String FIX_VERSION = "fixversion";
    private static final Iterable<String> FIELDS_THAT_EXCLUDE_VALUE = ImmutableSet.of((Object)"description", (Object)"environment");
    private static final Iterable<String> DURATION_FIELDS = ImmutableSet.of((Object)"timespent", (Object)"timeestimate", (Object)"timeoriginalestimate", (Object)"aggregatetimespent", (Object)"aggregatetimeestimate", (Object)"aggregatetimeoriginalestimate", (Object[])new String[0]);
    private static final Iterable<String> WORKLOG_FIELDS = ImmutableSet.of((Object)"timespent", (Object)"aggregatetimespent");
    private static final Iterable<String> MULTI_VALUE_FIELDS = ImmutableSet.of((Object)"version", (Object)"component", (Object)"fixversion");
    private final JiraHelper helper;
    private final AttachmentRendererFactory attachmentRendererFactory;
    private final I18nResolver i18nResolver;
    private final JiraAuthenticationContext authenticationContext;
    private final OutlookDateManager outlookDateManager;
    private final JiraDurationUtils jiraDurationUtils;
    private final ProjectComponentManager projectComponentManager;
    private final VersionService versionService;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final WorklogManager worklogManager;
    private final UriProvider uriProvider;
    private final StreamsEntryRendererFactory rendererFactory;
    private final IssueActivityObjectRendererFactory issueActivityObjectRendererFactory;
    private final TemplateRenderer templateRenderer;
    private final Function<Comment, Html> commentRenderer;
    private final UserKeyService userKeyService;
    private Function<GenericValue, String> toFieldName = new Function<GenericValue, String>(){

        public String apply(GenericValue changeItem) {
            return IssueUpdateRendererFactory.this.field(changeItem);
        }
    };

    IssueUpdateRendererFactory(JiraHelper helper, AttachmentRendererFactory attachmentRendererFactory, StreamsEntryRendererFactory rendererFactory, IssueActivityObjectRendererFactory issueActivityObjectRendererFactory, I18nResolver i18nResolver, JiraAuthenticationContext authenticationContext, OutlookDateManager outlookDateManager, ProjectComponentManager projectComponentManager, VersionService versionService, JiraAuthenticationContext jiraAuthenticationContext, WorklogManager worklogManager, UriProvider uriProvider, TemplateRenderer templateRenderer, UserKeyService userKeyService) {
        this.helper = (JiraHelper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
        this.attachmentRendererFactory = (AttachmentRendererFactory)Preconditions.checkNotNull((Object)attachmentRendererFactory, (Object)"attachmentRendererFactory");
        this.rendererFactory = (StreamsEntryRendererFactory)Preconditions.checkNotNull((Object)rendererFactory, (Object)"rendererFactory");
        this.issueActivityObjectRendererFactory = (IssueActivityObjectRendererFactory)Preconditions.checkNotNull((Object)issueActivityObjectRendererFactory, (Object)"issueActivityObjectRendererFactory");
        this.i18nResolver = (I18nResolver)Preconditions.checkNotNull((Object)i18nResolver, (Object)"i18nResolver");
        this.authenticationContext = (JiraAuthenticationContext)Preconditions.checkNotNull((Object)authenticationContext, (Object)"authenticationContext");
        this.outlookDateManager = (OutlookDateManager)Preconditions.checkNotNull((Object)outlookDateManager, (Object)"outlookDateManager");
        this.jiraDurationUtils = (JiraDurationUtils)ComponentManager.getComponentInstanceOfType(JiraDurationUtils.class);
        this.projectComponentManager = (ProjectComponentManager)Preconditions.checkNotNull((Object)projectComponentManager, (Object)"projectComponentManager");
        this.versionService = (VersionService)Preconditions.checkNotNull((Object)versionService, (Object)"versionService");
        this.jiraAuthenticationContext = (JiraAuthenticationContext)Preconditions.checkNotNull((Object)jiraAuthenticationContext, (Object)"jiraAuthenticationContext");
        this.worklogManager = (WorklogManager)Preconditions.checkNotNull((Object)worklogManager, (Object)"worklogManager");
        this.uriProvider = (UriProvider)Preconditions.checkNotNull((Object)uriProvider, (Object)"uriProvider");
        this.templateRenderer = (TemplateRenderer)Preconditions.checkNotNull((Object)templateRenderer, (Object)"templateRenderer");
        this.commentRenderer = helper.renderComment();
        this.userKeyService = userKeyService;
    }

    public StreamsEntry.Renderer newRenderer(JiraActivityItem item, URI baseUri, Iterable<GenericValue> changeItems) {
        if (Iterables.size(changeItems) == 1) {
            GenericValue changeItem = (GenericValue)Iterables.getOnlyElement(changeItems);
            if ("description".equals(this.field(changeItem))) {
                return this.newDescriptionChangeEntryRenderer(item, baseUri, changeItem);
            }
            return this.newSingleFieldChangedEntryRenderer(item, baseUri, changeItem);
        }
        if (this.uniqueFieldSize(changeItems) == 1) {
            return this.newSingleMultiValueFieldChangedEntryRenderer(item, baseUri, changeItems);
        }
        return this.newMultipleFieldsChangedEntryRenderer(item, baseUri, changeItems);
    }

    public StreamsEntry.Renderer newIssueLinkEntryRenderer(URI baseUri, AggregatedJiraActivityItem aggregatedItem) {
        return new IssueLinkEntryRenderer(baseUri, aggregatedItem);
    }

    public StreamsEntry.Renderer newRemoteIssueLinkEntryRenderer(URI baseUri, JiraActivityItem item, RemoteIssueLink remoteIssueLink) {
        return new RemoteIssueLinkEntryRenderer(baseUri, item, remoteIssueLink);
    }

    private StreamsEntry.Renderer newMultipleFieldsChangedEntryRenderer(JiraActivityItem item, URI baseUri, Iterable<GenericValue> changeItems) {
        return new MultipleFieldsChangedEntryRenderer(item, baseUri, changeItems);
    }

    private StreamsEntry.Renderer newSingleMultiValueFieldChangedEntryRenderer(JiraActivityItem item, URI baseUri, Iterable<GenericValue> changeItems) {
        return new SingleMultiValueFieldChangedEntryRenderer(item, baseUri, changeItems);
    }

    private StreamsEntry.Renderer newSingleFieldChangedEntryRenderer(JiraActivityItem item, URI baseUri, GenericValue changeItem) {
        Function<StreamsEntry.ActivityObject, Option<Html>> activityObjectRenderer = this.updatedSummary(changeItem) ? this.issueActivityObjectRendererFactory.newIssueActivityObjectRendererWithoutSummary(item.getIssue()) : this.issueActivityObjectRendererFactory.newIssueActivityObjectRendererWithSummary(item.getIssue());
        SingleFieldChangeTitleRenderer titleRenderer = new SingleFieldChangeTitleRenderer(item, baseUri, changeItem, activityObjectRenderer);
        if (this.worklogField(changeItem)) {
            return this.rendererFactory.newCommentRenderer((Function)titleRenderer, (Html)this.worklogComment(item).map(this.helper.renderCommentString(item.getIssue())).flatMap(Html.trimHtmlToNone()).getOrElse((Object)new Html("")));
        }
        return this.rendererFactory.newCommentRenderer((Function)titleRenderer, (Html)item.getComment().map(this.commentRenderer).flatMap(Html.trimHtmlToNone()).getOrElse((Object)new Html("")));
    }

    private StreamsEntry.Renderer newDescriptionChangeEntryRenderer(JiraActivityItem item, URI baseUri, GenericValue changeItem) {
        return new DescriptionChangeEntryRenderer(item, baseUri, changeItem);
    }

    String getI18nKey(GenericValue changeItem, boolean fromList) {
        if (this.multiValuedField(changeItem)) {
            return fromList ? "streams.item.jira.added.list.single" : "streams.item.jira.title.added.field";
        }
        if (this.worklogField(changeItem)) {
            String newValue;
            long delta;
            String oldValue;
            if (Iterables.contains(DURATION_FIELDS, (Object)this.field(changeItem)) && !StringUtils.isBlank((String)(oldValue = changeItem.getString("oldstring"))) && (delta = Long.parseLong(newValue = changeItem.getString("newstring")) - Long.parseLong(oldValue)) < 0L) {
                return fromList ? "streams.item.jira.updated.list.single.worklog.reduced" : "streams.item.jira.title.updated.field.worklog.reduced";
            }
            return fromList ? "streams.item.jira.updated.list.single.worklog" : "streams.item.jira.title.updated.field.worklog";
        }
        if (this.excludeValue(changeItem)) {
            return fromList ? "streams.item.jira.updated.list.single.exclude.value" : "streams.item.jira.title.updated.field.exclude.value";
        }
        if (this.updatedSummary(changeItem) && !fromList) {
            return "streams.item.jira.title.updated.field.summary";
        }
        return fromList ? "streams.item.jira.updated.list.single" : "streams.item.jira.title.updated.field";
    }

    private String getRemovedI18nKey(GenericValue changeItem, boolean fromList) {
        if (this.multiValuedField(changeItem)) {
            return fromList ? "streams.item.jira.removed.list" : "streams.item.jira.title.removed.field";
        }
        return fromList ? "streams.item.jira.removed.list.exclude.value" : "streams.item.jira.title.removed.field.exclude.value";
    }

    private String linkingText(JiraActivityItem item) {
        GenericValue changeItem = ChangeItems.getFirstChangeItem(item);
        String linkString = changeItem.getString("newstring");
        if (!StringUtils.isBlank((String)linkString) && linkString.startsWith("This issue ")) {
            return linkString.substring("This issue ".length(), linkString.lastIndexOf(" "));
        }
        return linkString;
    }

    private Option<String> worklogComment(JiraActivityItem item) {
        for (Long worklogId : ChangeItems.getWorklogId(item)) {
            String comment;
            Worklog worklog = this.worklogManager.getById(worklogId);
            if (worklog == null || StringUtils.isBlank((String)(comment = worklog.getComment()))) continue;
            return Option.some((Object)comment);
        }
        return Option.none();
    }

    private boolean worklogField(GenericValue changeItem) {
        return Iterables.contains(WORKLOG_FIELDS, (Object)this.field(changeItem));
    }

    private boolean multiValuedField(GenericValue changeItem) {
        return Iterables.contains(MULTI_VALUE_FIELDS, (Object)this.field(changeItem));
    }

    private boolean updatedSummary(GenericValue changeItem) {
        return "summary".equalsIgnoreCase(this.field(changeItem));
    }

    private Html getFieldName(GenericValue changeItem) {
        String field = this.field(changeItem);
        if (this.isCustomType(changeItem)) {
            return new Html(StringEscapeUtils.escapeHtml((String)changeItem.getString("field")));
        }
        if (this.multiValuedField(changeItem)) {
            return new Html(StringEscapeUtils.escapeHtml((String)this.i18nResolver.getText("streams.issue.field." + field)));
        }
        return new Html(StringEscapeUtils.escapeHtml((String)this.i18nResolver.getText("issue.field." + field)));
    }

    private Option<URI> fieldUri(JiraActivityItem item, URI baseUri, String field, String id) {
        if (StringUtils.isBlank((String)id) || StringUtils.isBlank((String)field)) {
            return Option.none();
        }
        if (COMPONENT.equalsIgnoreCase(field)) {
            try {
                return Option.some((Object)this.uriProvider.getComponentUri(baseUri, item.getIssue(), this.projectComponentManager.find(Long.valueOf(id))));
            }
            catch (Exception e) {
                return Option.none();
            }
        }
        if (AFFECTS_VERSION.equalsIgnoreCase(field) || FIX_VERSION.equalsIgnoreCase(field)) {
            Version version = this.versionService.getVersionById(this.jiraAuthenticationContext.getLoggedInUser(), Long.valueOf(id)).getVersion();
            if (version == null) {
                return Option.none();
            }
            return Option.some((Object)this.uriProvider.getFixForVersionUri(baseUri, version));
        }
        return Option.none();
    }

    private String field(GenericValue changeItem) {
        return changeItem.getString("field").replaceAll(" ", "").toLowerCase();
    }

    private boolean excludeValue(GenericValue changeItem) {
        return Iterables.contains(FIELDS_THAT_EXCLUDE_VALUE, (Object)this.field(changeItem)) || this.isCustomType(changeItem);
    }

    private boolean isCustomType(GenericValue changeItem) {
        String fieldType = changeItem.getString("fieldtype");
        return fieldType != null && fieldType.toLowerCase().equals("custom");
    }

    private int uniqueFieldSize(Iterable<GenericValue> changeItems) {
        return Iterables.size((Iterable)ImmutableSet.copyOf((Iterable)Iterables.transform(changeItems, this.toFieldName)));
    }

    private Option<Html> newValue(URI baseUri, GenericValue changeItem) {
        String field = this.field(changeItem);
        Iterator i$ = this.helper.getNewChangeItemNameTranslation(changeItem).iterator();
        if (i$.hasNext()) {
            String newValue = (String)i$.next();
            if ("assignee".equalsIgnoreCase(field) || "reporter".equalsIgnoreCase(field)) {
                String newAssigneeOrReporterName = this.userKeyService.getUsernameForKey(changeItem.getString("newvalue"));
                return Option.some((Object)this.rendererFactory.newUserProfileRenderer().apply((Object)ImmutableNonEmptyList.of((Object)this.helper.getUserProfile(baseUri).apply((Object)newAssigneeOrReporterName))));
            }
            if ("duedate".equalsIgnoreCase(field)) {
                OutlookDate outlookDate = this.outlookDateManager.getOutlookDate(this.authenticationContext.getLocale());
                try {
                    return Option.some((Object)new Html(outlookDate.formatDatePicker((Date)Timestamp.valueOf(newValue))));
                }
                catch (IllegalArgumentException e) {
                    return Option.none();
                }
            }
            if (Iterables.contains(DURATION_FIELDS, (Object)field)) {
                String oldValue = changeItem.getString("oldstring");
                if (this.worklogField(changeItem) && !StringUtils.isBlank((String)oldValue)) {
                    long delta = Long.parseLong(newValue) - Long.parseLong(oldValue);
                    if (delta < 0L) {
                        delta = -delta;
                    }
                    return Option.some((Object)new Html(this.jiraDurationUtils.getFormattedDuration(Long.valueOf(delta))));
                }
                return Option.some((Object)new Html(this.jiraDurationUtils.getFormattedDuration(Long.valueOf(newValue))));
            }
            return Option.some((Object)new Html(StringEscapeUtils.escapeHtml((String)newValue)));
        }
        return Option.none();
    }

    private Html oldValue(GenericValue changeItem) {
        Iterator i$ = this.helper.getOldChangeItemNameTranslation(changeItem).iterator();
        if (i$.hasNext()) {
            String oldValue = (String)i$.next();
            return new Html(StringEscapeUtils.escapeHtml((String)oldValue));
        }
        return new Html("");
    }

    private final class IssueRenderer
    implements Function<JiraActivityItem, Option<Html>> {
        private final TemplateRenderer templateRenderer;
        private final boolean withSummary;
        private final URI baseUri;

        private IssueRenderer(TemplateRenderer templateRenderer, URI baseUri, boolean withSummary) {
            this.baseUri = (URI)Preconditions.checkNotNull((Object)baseUri);
            this.templateRenderer = (TemplateRenderer)Preconditions.checkNotNull((Object)templateRenderer, (Object)"templateRenderer");
            this.withSummary = withSummary;
        }

        public Option<Html> apply(JiraActivityItem activityItem) {
            return Option.some((Object)new Html(Renderers.render((TemplateRenderer)this.templateRenderer, (String)"jira-issue-link.vm", (Map)ImmutableMap.of((Object)"issue", (Object)activityItem.getIssue(), (Object)"issueUri", (Object)IssueUpdateRendererFactory.this.uriProvider.getIssueUri(this.baseUri, activityItem.getIssue()).toASCIIString(), (Object)"issueSummary", (Object)activityItem.getDisplaySummary(), (Object)"withSummary", (Object)this.withSummary))));
        }
    }

    private final class IssuesRenderer
    implements Function<Iterable<JiraActivityItem>, Html> {
        private final Function<Iterable<JiraActivityItem>, Option<Html>> compoundRenderer;

        public IssuesRenderer(Function<JiraActivityItem, Option<Html>> issueRenderer) {
            this.compoundRenderer = IssueUpdateRendererFactory.this.rendererFactory.newCompoundStatementRenderer(issueRenderer);
        }

        @HtmlSafe
        public Html apply(Iterable<JiraActivityItem> activityItems) {
            return (Html)((Option)this.compoundRenderer.apply(activityItems)).get();
        }
    }

    private final class RemoteIssueLinkEntryRenderer
    implements StreamsEntry.Renderer {
        private final Function<Iterable<UserProfile>, Html> authorsRenderer;
        private final Function<JiraActivityItem, Option<Html>> issueRenderer;
        private final JiraActivityItem item;
        private final RemoteIssueLink remoteIssueLink;
        private final boolean updated;

        public RemoteIssueLinkEntryRenderer(URI baseUri, JiraActivityItem item, RemoteIssueLink remoteIssueLink) {
            this.authorsRenderer = IssueUpdateRendererFactory.this.rendererFactory.newAuthorsRenderer();
            this.item = item;
            this.remoteIssueLink = remoteIssueLink;
            this.issueRenderer = new IssueRenderer(IssueUpdateRendererFactory.this.templateRenderer, baseUri, true);
            this.updated = this.updated(item);
        }

        public Html renderTitleAsHtml(StreamsEntry entry) {
            Html remoteIssueLinkHtml = new Html(Renderers.render((TemplateRenderer)IssueUpdateRendererFactory.this.templateRenderer, (String)"jira-remote-issue-link.vm", (Map)ImmutableMap.of((Object)"remoteIssueLink", (Object)this.remoteIssueLink, (Object)"withSummary", (Object)false)));
            if (this.updated) {
                return new Html(IssueUpdateRendererFactory.this.i18nResolver.getText("streams.item.jira.title.update.linked.remote", new Serializable[]{(Serializable)this.authorsRenderer.apply((Object)entry.getAuthors()), (Serializable)((Option)this.issueRenderer.apply((Object)this.item)).get(), remoteIssueLinkHtml, this.getEscapedApplicationName()}));
            }
            return new Html(IssueUpdateRendererFactory.this.i18nResolver.getText("streams.item.jira.title.linked.remote", new Serializable[]{(Serializable)this.authorsRenderer.apply((Object)entry.getAuthors()), (Serializable)((Option)this.issueRenderer.apply((Object)this.item)).get(), remoteIssueLinkHtml, this.getEscapedApplicationName()}));
        }

        public Option<Html> renderSummaryAsHtml(StreamsEntry entry) {
            return Option.none();
        }

        public Option<Html> renderContentAsHtml(StreamsEntry entry) {
            return Option.some((Object)new Html(Renderers.render((TemplateRenderer)IssueUpdateRendererFactory.this.templateRenderer, (String)"jira-remote-issue-comment-block.vm", (Map)ImmutableMap.of((Object)"comment", (Object)this.item.getComment().map(IssueUpdateRendererFactory.this.helper.renderComment()).flatMap(Html.trimHtmlToNone())))));
        }

        private boolean updated(JiraActivityItem item) {
            return IssueUpdateRendererFactory.this.helper.getOldChangeItemNameTranslation(ChangeItems.getFirstChangeItem(item)).isDefined();
        }

        private String getEscapedApplicationName() {
            return RenderingUtilities.htmlEncode((String)Option.option((Object)this.remoteIssueLink.getApplicationName()).getOrElse((Object)IssueUpdateRendererFactory.this.i18nResolver.getText("remotelink.manager.changeitem.applicationname.default")));
        }
    }

    private final class IssueLinkEntryRenderer
    implements StreamsEntry.Renderer {
        private final Function<Iterable<UserProfile>, Html> authorsRenderer;
        private final Function<JiraActivityItem, Option<Html>> issueRenderer;
        private final Function<Iterable<JiraActivityItem>, Html> issuesRenderer;
        private final AggregatedJiraActivityItem aggregatedItem;
        private final boolean removed;
        private final Function<JiraActivityItem, Option<Html>> toCommentHtml;

        public IssueLinkEntryRenderer(URI baseUri, AggregatedJiraActivityItem aggregatedItem) {
            this.authorsRenderer = IssueUpdateRendererFactory.this.rendererFactory.newAuthorsRenderer();
            this.toCommentHtml = new Function<JiraActivityItem, Option<Html>>(){

                public Option<Html> apply(JiraActivityItem activityItem) {
                    return activityItem.getComment().map(IssueUpdateRendererFactory.this.commentRenderer).flatMap(Html.trimHtmlToNone());
                }
            };
            this.aggregatedItem = aggregatedItem;
            this.issueRenderer = new IssueRenderer(IssueUpdateRendererFactory.this.templateRenderer, baseUri, true);
            this.issuesRenderer = new IssuesRenderer(this.issueRenderer);
            this.removed = this.removed(baseUri, aggregatedItem.getActivityItem());
        }

        public Html renderTitleAsHtml(StreamsEntry entry) {
            if (this.removed) {
                return new Html(IssueUpdateRendererFactory.this.i18nResolver.getText("streams.item.jira.title.remove.linked", new Serializable[]{(Serializable)this.authorsRenderer.apply((Object)entry.getAuthors()), (Serializable)Option.some((Object)this.aggregatedItem.getActivityItem()).flatMap(this.issueRenderer).get(), (Serializable)this.issuesRenderer.apply(this.aggregatedItem.getRelatedActivityItems().getOrElse((Object)ImmutableList.of()))}));
            }
            return new Html(IssueUpdateRendererFactory.this.i18nResolver.getText("streams.item.jira.title.linked", new Serializable[]{(Serializable)this.authorsRenderer.apply((Object)entry.getAuthors()), Integer.valueOf(Iterables.size((Iterable)((Iterable)this.aggregatedItem.getRelatedActivityItems().getOrElse((Object)ImmutableList.of()))) + 1)}));
        }

        public Option<Html> renderSummaryAsHtml(StreamsEntry entry) {
            return Option.none();
        }

        public Option<Html> renderContentAsHtml(StreamsEntry entry) {
            if (!this.removed) {
                return Option.some((Object)new Html(Renderers.render((TemplateRenderer)IssueUpdateRendererFactory.this.templateRenderer, (String)"jira-link-field-update.vm", (Map)ImmutableMap.of((Object)"comment", this.getAggregatedComments(this.aggregatedItem), (Object)"issueKeyHtml", (Object)Option.some((Object)this.aggregatedItem.getActivityItem()).flatMap(this.issueRenderer).get(), (Object)"linkText", (Object)IssueUpdateRendererFactory.this.linkingText(this.aggregatedItem.getActivityItem()), (Object)"linkedIssueKeysHtml", (Object)this.issuesRenderer.apply(this.aggregatedItem.getRelatedActivityItems().getOrElse((Object)ImmutableList.of()))))));
            }
            return Option.none();
        }

        private Iterable<Html> getAggregatedComments(AggregatedJiraActivityItem aggregatedItem) {
            ImmutableList items = ImmutableList.builder().add((Object)aggregatedItem.getActivityItem()).addAll((Iterable)aggregatedItem.getRelatedActivityItems().getOrElse((Object)ImmutableList.of())).build();
            return Options.catOptions((Iterable)Iterables.transform((Iterable)items, this.toCommentHtml));
        }

        private boolean removed(URI baseUri, JiraActivityItem item) {
            return !IssueUpdateRendererFactory.this.newValue(baseUri, ChangeItems.getFirstChangeItem(item)).isDefined();
        }
    }

    private final class DescriptionChangeEntryRenderer
    implements StreamsEntry.Renderer {
        private final JiraActivityItem item;
        private final GenericValue changeItem;
        private final Function<StreamsEntry, Html> titleRenderer;
        private final Function<Boolean, Option<Html>> renderDescription;

        public DescriptionChangeEntryRenderer(JiraActivityItem item, URI baseUri, GenericValue changeItem) {
            this.item = item;
            this.changeItem = changeItem;
            this.titleRenderer = new SingleFieldChangeTitleRenderer(item, baseUri, changeItem, IssueUpdateRendererFactory.this.issueActivityObjectRendererFactory.newIssueActivityObjectRendererWithSummary(item.getIssue()));
            this.renderDescription = this.renderDescription(baseUri, item.getIssue());
        }

        public Html renderTitleAsHtml(StreamsEntry entry) {
            return (Html)this.titleRenderer.apply((Object)entry);
        }

        public Option<Html> renderSummaryAsHtml(StreamsEntry entry) {
            return (Option)this.renderDescription.apply((Object)true);
        }

        public Option<Html> renderContentAsHtml(StreamsEntry entry) {
            return (Option)this.renderDescription.apply((Object)false);
        }

        private Function<Boolean, Option<Html>> renderDescription(final URI baseUri, final Issue issue) {
            final Option<Html> description = this.getDescription(issue);
            return new Function<Boolean, Option<Html>>(){

                public Option<Html> apply(Boolean truncate) {
                    return description.flatMap(this.renderContent(truncate));
                }

                private Function<Html, Option<Html>> renderContent(final boolean truncate) {
                    return new Function<Html, Option<Html>>(){

                        public Option<Html> apply(Html d) {
                            Html description;
                            Html html = description = truncate ? Renderers.truncate((int)250, (Html)d) : d;
                            if (truncate && d.equals((Object)description)) {
                                return Option.none();
                            }
                            ImmutableMap context = ImmutableMap.builder().put((Object)"contentHtml", (Object)description).put((Object)"truncated", (Object)truncate).put((Object)"contentUri", (Object)IssueUpdateRendererFactory.this.uriProvider.getIssueUri(baseUri, issue.getKey())).put((Object)"comment", (Object)DescriptionChangeEntryRenderer.this.item.getComment().map(IssueUpdateRendererFactory.this.commentRenderer).flatMap(Html.trimHtmlToNone())).build();
                            return Option.some((Object)new Html(Renderers.render((TemplateRenderer)IssueUpdateRendererFactory.this.templateRenderer, (String)"jira-description-field-update.vm", (Map)context)));
                        }
                    };
                }
            };
        }

        private Option<Html> getDescription(Issue issue) {
            String newValueString = this.changeItem.getString("newstring");
            if (!StringUtils.isBlank((String)newValueString)) {
                return Option.option((Object)IssueUpdateRendererFactory.this.helper.renderIssueFieldValue(issue, "description", newValueString)).flatMap(Html.trimHtmlToNone());
            }
            return Option.none();
        }
    }

    private final class SingleFieldChangeTitleRenderer
    implements Function<StreamsEntry, Html> {
        private final Function<Iterable<UserProfile>, Html> authorsRenderer;
        private final Function<Iterable<StreamsEntry.ActivityObject>, Option<Html>> activityObjectsRenderer;
        private final GenericValue changeItem;
        private final JiraActivityItem item;
        private final URI baseUri;

        public SingleFieldChangeTitleRenderer(JiraActivityItem item, URI baseUri, GenericValue changeItem, Function<StreamsEntry.ActivityObject, Option<Html>> activityObjectRenderer) {
            this.authorsRenderer = IssueUpdateRendererFactory.this.rendererFactory.newAuthorsRenderer();
            this.item = item;
            this.baseUri = baseUri;
            this.changeItem = changeItem;
            this.activityObjectsRenderer = IssueUpdateRendererFactory.this.rendererFactory.newActivityObjectsRenderer(activityObjectRenderer);
        }

        public Html apply(StreamsEntry entry) {
            Iterator i$ = IssueUpdateRendererFactory.this.newValue(this.baseUri, this.changeItem).iterator();
            if (i$.hasNext()) {
                Html newValue = (Html)i$.next();
                return new Html(IssueUpdateRendererFactory.this.i18nResolver.getText(IssueUpdateRendererFactory.this.getI18nKey(this.changeItem, false), new Serializable[]{(Serializable)this.authorsRenderer.apply((Object)entry.getAuthors()), IssueUpdateRendererFactory.this.getFieldName(this.changeItem), RenderingUtilities.link((Option<URI>)IssueUpdateRendererFactory.this.fieldUri(this.item, this.baseUri, IssueUpdateRendererFactory.this.field(this.changeItem), this.changeItem.getString("newvalue")), newValue), (Serializable)((Option)this.activityObjectsRenderer.apply((Object)entry.getActivityObjects())).get()}));
            }
            return new Html(IssueUpdateRendererFactory.this.i18nResolver.getText(IssueUpdateRendererFactory.this.getRemovedI18nKey(this.changeItem, false), new Serializable[]{(Serializable)this.authorsRenderer.apply((Object)entry.getAuthors()), IssueUpdateRendererFactory.this.getFieldName(this.changeItem), (Serializable)((Option)this.activityObjectsRenderer.apply((Object)entry.getActivityObjects())).get(), RenderingUtilities.link((Option<URI>)IssueUpdateRendererFactory.this.fieldUri(this.item, this.baseUri, IssueUpdateRendererFactory.this.field(this.changeItem), this.changeItem.getString("oldvalue")), IssueUpdateRendererFactory.this.oldValue(this.changeItem))}));
        }
    }

    private abstract class MultipleValueChangedEntryRenderer
    implements StreamsEntry.Renderer {
        final Function<Iterable<UserProfile>, Html> authorsRenderer;
        final Function<Iterable<StreamsEntry.ActivityObject>, Option<Html>> activityObjectsRenderer;
        final Function<Iterable<Attachment>, Html> attachmentsRenderer;
        final JiraActivityItem item;
        final List<Attachment> attachments;
        final List<GenericValue> fieldChanges;
        final URI baseUri;
        private final Function<GenericValue, Html> fieldChangeRenderer;

        public MultipleValueChangedEntryRenderer(JiraActivityItem item, URI baseUri, Iterable<GenericValue> changeItems) {
            this.authorsRenderer = IssueUpdateRendererFactory.this.rendererFactory.newAuthorsRenderer();
            this.fieldChangeRenderer = new Function<GenericValue, Html>(){

                public Html apply(GenericValue changeItem) {
                    Iterator i$ = IssueUpdateRendererFactory.this.newValue(MultipleValueChangedEntryRenderer.this.baseUri, changeItem).iterator();
                    if (i$.hasNext()) {
                        Html newValue = (Html)i$.next();
                        return MultipleValueChangedEntryRenderer.this.renderFieldChange(changeItem, IssueUpdateRendererFactory.this.getI18nKey(changeItem, true), newValue, changeItem.getString("newvalue"));
                    }
                    return MultipleValueChangedEntryRenderer.this.renderFieldChange(changeItem, IssueUpdateRendererFactory.this.getRemovedI18nKey(changeItem, true), IssueUpdateRendererFactory.this.oldValue(changeItem), changeItem.getString("oldvalue"));
                }
            };
            this.item = item;
            this.baseUri = baseUri;
            this.attachmentsRenderer = IssueUpdateRendererFactory.this.attachmentRendererFactory.newAttachmentsRendererWithoutComment(item, baseUri);
            this.activityObjectsRenderer = IssueUpdateRendererFactory.this.issueActivityObjectRendererFactory.newIssueActivityObjectsRenderer(item.getIssue());
            this.attachments = ImmutableList.copyOf(IssueUpdateRendererFactory.this.helper.extractAttachments(changeItems));
            this.fieldChanges = ImmutableList.copyOf((Iterable)Iterables.filter(changeItems, (Predicate)Predicates.not(ChangeItems.isAttachment())));
        }

        public Option<Html> renderContentAsHtml(StreamsEntry entry) {
            return Option.some((Object)new Html(Renderers.render((TemplateRenderer)IssueUpdateRendererFactory.this.templateRenderer, (String)"updated-field-list.vm", (Map)ImmutableMap.of((Object)"comment", (Object)this.item.getComment().map(IssueUpdateRendererFactory.this.commentRenderer).flatMap(Html.trimHtmlToNone()), (Object)"fieldChanges", (Object)Iterables.transform(this.fieldChanges, this.renderFieldChanges()), (Object)"attachments", this.attachments, (Object)"attachmentsRenderer", this.attachmentsRenderer))));
        }

        private Html renderFieldChange(GenericValue changeItem, String i18nKey, Html displayValue, String id) {
            return new Html(Renderers.render((TemplateRenderer)IssueUpdateRendererFactory.this.templateRenderer, (String)"jira-field-change-item.vm", (Map)ImmutableMap.of((Object)"i18nKey", (Object)i18nKey, (Object)"fieldName", (Object)IssueUpdateRendererFactory.this.getFieldName(changeItem), (Object)"fieldValue", (Object)displayValue, (Object)"fieldUri", (Object)IssueUpdateRendererFactory.this.fieldUri(this.item, this.baseUri, IssueUpdateRendererFactory.this.field(changeItem), id))));
        }

        private Function<GenericValue, Html> renderFieldChanges() {
            return this.fieldChangeRenderer;
        }

        public Option<Html> renderSummaryAsHtml(StreamsEntry entry) {
            return Option.none();
        }
    }

    private final class SingleMultiValueFieldChangedEntryRenderer
    extends MultipleValueChangedEntryRenderer {
        public SingleMultiValueFieldChangedEntryRenderer(JiraActivityItem item, URI baseUri, Iterable<GenericValue> changeItems) {
            super(item, baseUri, changeItems);
        }

        public Html renderTitleAsHtml(StreamsEntry entry) {
            return new Html(IssueUpdateRendererFactory.this.i18nResolver.getText("streams.item.jira.title.updated.field.exclude.value", new Serializable[]{(Serializable)this.authorsRenderer.apply((Object)entry.getAuthors()), IssueUpdateRendererFactory.this.getFieldName((GenericValue)Iterables.get((Iterable)this.fieldChanges, (int)0)), Integer.valueOf(Math.min(this.attachments.size(), 1) + IssueUpdateRendererFactory.this.uniqueFieldSize(this.fieldChanges)), (Serializable)((Option)this.activityObjectsRenderer.apply((Object)entry.getActivityObjects())).get()}));
        }
    }

    private final class MultipleFieldsChangedEntryRenderer
    extends MultipleValueChangedEntryRenderer {
        public MultipleFieldsChangedEntryRenderer(JiraActivityItem item, URI baseUri, Iterable<GenericValue> changeItems) {
            super(item, baseUri, changeItems);
        }

        public Html renderTitleAsHtml(StreamsEntry entry) {
            return new Html(IssueUpdateRendererFactory.this.i18nResolver.getText("streams.item.jira.title.updated.multiple.fields", new Serializable[]{(Serializable)this.authorsRenderer.apply((Object)entry.getAuthors()), Integer.valueOf(Math.min(this.attachments.size(), 1) + IssueUpdateRendererFactory.this.uniqueFieldSize(this.fieldChanges)), (Serializable)((Option)this.activityObjectsRenderer.apply((Object)entry.getActivityObjects())).get()}));
        }
    }
}

