/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.jira.renderer;

import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.streams.api.ActivityVerb;
import com.atlassian.streams.api.Html;
import com.atlassian.streams.api.StreamsEntry;
import com.atlassian.streams.api.UserProfile;
import com.atlassian.streams.api.common.Option;
import com.atlassian.streams.api.common.Pair;
import com.atlassian.streams.api.renderer.StreamsEntryRendererFactory;
import com.atlassian.streams.jira.ChangeItems;
import com.atlassian.streams.jira.JiraActivityItem;
import com.atlassian.streams.jira.JiraHelper;
import com.atlassian.streams.jira.UriProvider;
import com.atlassian.streams.jira.renderer.IssueActivityObjectRendererFactory;
import com.atlassian.streams.spi.renderer.Renderers;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.opensymphony.util.TextUtils;
import java.io.Serializable;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

public class IssueTransitionRendererFactory {
    private final StreamsEntryRendererFactory rendererFactory;
    private final I18nResolver i18nResolver;
    private final IssueActivityObjectRendererFactory issueActivityObjectRendererFactory;
    private final TemplateRenderer templateRenderer;
    private final UriProvider uriProvider;
    private final Function<Comment, Html> commentRenderer;
    private final JiraHelper helper;

    public IssueTransitionRendererFactory(StreamsEntryRendererFactory rendererFactory, I18nResolver i18nResolver, IssueActivityObjectRendererFactory issueActivityObjectRendererFactory, TemplateRenderer templateRenderer, UriProvider uriProvider, JiraHelper helper) {
        this.rendererFactory = (StreamsEntryRendererFactory)Preconditions.checkNotNull((Object)rendererFactory, (Object)"rendererFactory");
        this.i18nResolver = (I18nResolver)Preconditions.checkNotNull((Object)i18nResolver, (Object)"i18nResolver");
        this.issueActivityObjectRendererFactory = (IssueActivityObjectRendererFactory)Preconditions.checkNotNull((Object)issueActivityObjectRendererFactory, (Object)"issueActivityObjectRendererFactory");
        this.templateRenderer = (TemplateRenderer)Preconditions.checkNotNull((Object)templateRenderer, (Object)"templateRenderer");
        this.uriProvider = (UriProvider)Preconditions.checkNotNull((Object)uriProvider, (Object)"uriProvider");
        this.helper = (JiraHelper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
        this.commentRenderer = helper.renderComment();
    }

    public StreamsEntry.Renderer newCustomTransitionRenderer(JiraActivityItem item, URI baseUri, String statusName) {
        return new CustomTransitionRenderer(item, baseUri, statusName);
    }

    public StreamsEntry.Renderer newResolvedRenderer(JiraActivityItem item, URI baseUri) {
        return new ResolvedRenderer(item, baseUri);
    }

    public StreamsEntry.Renderer newSystemTransitionRenderer(JiraActivityItem item, URI baseUri, ActivityVerb verb) {
        return new SystemTransitionRenderer(item, baseUri, verb);
    }

    private Option<String> getResolution(JiraActivityItem item) {
        for (GenericValue changeItem : ChangeItems.getChangeItems(item)) {
            if (!"resolution".equalsIgnoreCase(changeItem.getString("field"))) continue;
            return this.helper.getNewChangeItemNameTranslation(changeItem);
        }
        return Option.none();
    }

    private final class CustomTransitionRenderer
    extends TransitionRenderer {
        private final Function<Iterable<UserProfile>, Html> authorsRenderer;
        private final Function<Iterable<StreamsEntry.ActivityObject>, Option<Html>> activityObjectsRenderer;
        private final String statusName;

        public CustomTransitionRenderer(JiraActivityItem item, URI baseUri, String statusName) {
            super(item, baseUri);
            this.authorsRenderer = IssueTransitionRendererFactory.this.rendererFactory.newAuthorsRenderer();
            this.statusName = statusName;
            this.activityObjectsRenderer = IssueTransitionRendererFactory.this.issueActivityObjectRendererFactory.newIssueActivityObjectsRenderer(item.getIssue());
        }

        public Html renderTitleAsHtml(StreamsEntry entry) {
            return (Html)IssueTransitionRendererFactory.this.getResolution(this.item()).map(this.transitionWithResolution(entry)).getOrElse((Object)this.transitionWithoutResolution(entry));
        }

        private Function<String, Html> transitionWithResolution(final StreamsEntry entry) {
            return new Function<String, Html>(){

                public Html apply(String resolution) {
                    return new Html(IssueTransitionRendererFactory.this.i18nResolver.getText("streams.item.jira.status.transition.with.resolution", new Serializable[]{(Serializable)CustomTransitionRenderer.this.authorsRenderer.apply((Object)entry.getAuthors()), TextUtils.htmlEncode((String)CustomTransitionRenderer.this.statusName), (Serializable)((Option)CustomTransitionRenderer.this.activityObjectsRenderer.apply((Object)entry.getActivityObjects())).get(), TextUtils.htmlEncode((String)resolution)}));
                }
            };
        }

        private Html transitionWithoutResolution(StreamsEntry entry) {
            return new Html(IssueTransitionRendererFactory.this.i18nResolver.getText("streams.item.jira.status.transition.without.resolution", new Serializable[]{(Serializable)this.authorsRenderer.apply((Object)entry.getAuthors()), TextUtils.htmlEncode((String)this.statusName), (Serializable)((Option)this.activityObjectsRenderer.apply((Object)entry.getActivityObjects())).get()}));
        }
    }

    private final class SystemTransitionRenderer
    extends TransitionRenderer {
        private final Function<StreamsEntry, Html> titleRenderer;

        SystemTransitionRenderer(JiraActivityItem item, URI baseUri, ActivityVerb verb) {
            super(item, baseUri);
            this.titleRenderer = IssueTransitionRendererFactory.this.rendererFactory.newTitleRenderer("streams.item.jira.status." + verb.key(), IssueTransitionRendererFactory.this.rendererFactory.newAuthorsRenderer(), Option.some(IssueTransitionRendererFactory.this.issueActivityObjectRendererFactory.newIssueActivityObjectsRenderer(item.getIssue())), Option.some((Object)IssueTransitionRendererFactory.this.rendererFactory.newActivityObjectRendererWithSummary()));
        }

        public Html renderTitleAsHtml(StreamsEntry entry) {
            return (Html)this.titleRenderer.apply((Object)entry);
        }
    }

    private final class ResolvedRenderer
    extends TransitionRenderer {
        private final Function<Iterable<UserProfile>, Html> authorsRenderer;
        private final Function<Iterable<StreamsEntry.ActivityObject>, Option<Html>> activityObjectsRenderer;

        public ResolvedRenderer(JiraActivityItem item, URI baseUri) {
            super(item, baseUri);
            this.authorsRenderer = IssueTransitionRendererFactory.this.rendererFactory.newAuthorsRenderer();
            this.activityObjectsRenderer = IssueTransitionRendererFactory.this.issueActivityObjectRendererFactory.newIssueActivityObjectsRenderer(item.getIssue());
        }

        public Html renderTitleAsHtml(StreamsEntry entry) {
            Iterator i$ = IssueTransitionRendererFactory.this.getResolution(this.item()).iterator();
            if (i$.hasNext()) {
                String resolution = (String)i$.next();
                return new Html(IssueTransitionRendererFactory.this.i18nResolver.getText("streams.item.jira.status.resolved.with.resolution", new Serializable[]{(Serializable)this.authorsRenderer.apply((Object)entry.getAuthors()), (Serializable)((Option)this.activityObjectsRenderer.apply((Object)entry.getActivityObjects())).get(), TextUtils.htmlEncode((String)resolution)}));
            }
            return new Html(IssueTransitionRendererFactory.this.i18nResolver.getText("streams.item.jira.status.resolved.without.resolution", new Serializable[]{(Serializable)this.authorsRenderer.apply((Object)entry.getAuthors()), (Serializable)((Option)this.activityObjectsRenderer.apply((Object)entry.getActivityObjects())).get()}));
        }
    }

    private abstract class TransitionRenderer
    implements StreamsEntry.Renderer {
        private final JiraActivityItem item;
        private final URI baseUri;
        Supplier<Option<Pair<Comment, Html>>> commentHtml = Suppliers.memoize((Supplier)new Supplier<Option<Pair<Comment, Html>>>(){

            public Option<Pair<Comment, Html>> get() {
                if (!TransitionRenderer.this.item.getComment().isDefined()) {
                    return Option.none();
                }
                return Option.some((Object)Pair.pair((Object)TransitionRenderer.this.item.getComment().get(), (Object)TransitionRenderer.this.item.getComment().map(IssueTransitionRendererFactory.this.commentRenderer).get()));
            }
        });

        public TransitionRenderer(JiraActivityItem item, URI baseUri) {
            this.item = item;
            this.baseUri = baseUri;
        }

        public JiraActivityItem item() {
            return this.item;
        }

        public final Option<Html> renderContentAsHtml(StreamsEntry entry) {
            return ((Option)this.commentHtml.get()).flatMap(this.renderComment(false));
        }

        public final Option<Html> renderSummaryAsHtml(StreamsEntry entry) {
            return ((Option)this.commentHtml.get()).flatMap(this.renderComment(true));
        }

        private Function<Pair<Comment, Html>, Option<Html>> renderComment(final boolean truncate) {
            return new Function<Pair<Comment, Html>, Option<Html>>(){

                public Option<Html> apply(Pair<Comment, Html> comment) {
                    Html commentHtml;
                    Html html = commentHtml = truncate ? Renderers.truncate((int)250, (Html)((Html)comment.second())) : (Html)comment.second();
                    if (truncate && ((Html)comment.second()).equals((Object)commentHtml)) {
                        return Option.none();
                    }
                    ImmutableMap context = ImmutableMap.builder().put((Object)"contentHtml", (Object)commentHtml).put((Object)"truncated", (Object)truncate).put((Object)"contentUri", (Object)IssueTransitionRendererFactory.this.uriProvider.getIssueCommentUri(TransitionRenderer.this.baseUri, (Comment)comment.first())).build();
                    return Option.some((Object)new Html(Renderers.render((TemplateRenderer)IssueTransitionRendererFactory.this.templateRenderer, (String)"jira-comment-block.vm", (Map)context)));
                }
            };
        }
    }
}

