/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.jira.changehistory;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.changehistory.ChangeHistory;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.streams.jira.changehistory.IssueHistory;
import com.atlassian.streams.jira.changehistory.IssueHistoryReader;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

class BulkIssueHistoryReader
implements IssueHistoryReader {
    private final ChangeHistoryManager changeHistoryManager;

    public BulkIssueHistoryReader(ChangeHistoryManager changeHistoryManager) throws NoSuchMethodException {
        this.changeHistoryManager = changeHistoryManager;
    }

    @Override
    public Iterable<IssueHistory> getChangeHistoriesForUser(final Iterable<Issue> issues, final ApplicationUser remoteUser) {
        return new Iterable<IssueHistory>(){

            @Override
            public Iterator<IssueHistory> iterator() {
                try {
                    return new BulkIterator((Iterable)Preconditions.checkNotNull((Object)issues, (Object)"issues"), ApplicationUsers.toDirectoryUser((ApplicationUser)remoteUser));
                }
                catch (Exception e) {
                    throw new RuntimeException("Error creating BulkIterator", e);
                }
            }
        };
    }

    private Multimap<Issue, ChangeHistory> doGetChangeHistoriesForUser(Iterable<Issue> issues, User remoteUser) throws IllegalAccessException, InvocationTargetException {
        List histories = this.changeHistoryManager.getChangeHistoriesForUser(issues, remoteUser);
        return Multimaps.index((Iterable)histories, (Function)new ByIssueIndexer());
    }

    private static class ByIssueIndexer
    implements Function<ChangeHistory, Issue> {
        private ByIssueIndexer() {
        }

        public Issue apply(ChangeHistory changeHistory) {
            return changeHistory != null ? changeHistory.getIssue() : null;
        }
    }

    private class BulkIterator
    implements Iterator<IssueHistory> {
        private final Iterator<Issue> issues;
        private final Multimap<Issue, ChangeHistory> changeHistories;

        private BulkIterator(Iterable<Issue> issues, User remoteUser) throws InvocationTargetException, IllegalAccessException {
            this.changeHistories = BulkIssueHistoryReader.this.doGetChangeHistoriesForUser(issues, remoteUser);
            this.issues = this.changeHistories.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.issues.hasNext();
        }

        @Override
        public IssueHistory next() {
            Issue nextIssue = this.issues.next();
            Collection nextChangeHistories = this.changeHistories.get((Object)nextIssue);
            return new IssueHistory(nextIssue, (ImmutableCollection<ChangeHistory>)ImmutableList.copyOf((Collection)nextChangeHistories));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

