/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.jira.builder;

import com.atlassian.streams.api.ActivityRequest;
import com.atlassian.streams.api.ActivityVerb;
import com.atlassian.streams.api.StreamsEntry;
import com.atlassian.streams.api.common.Option;
import com.atlassian.streams.jira.AggregatedJiraActivityItem;
import com.atlassian.streams.jira.ChangeItems;
import com.atlassian.streams.jira.JiraActivityItem;
import com.atlassian.streams.jira.JiraActivityVerbs;
import com.atlassian.streams.jira.builder.GeneralUpdateEntryBuilder;
import com.atlassian.streams.jira.builder.StatusChangeEntryBuilder;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Iterator;
import org.ofbiz.core.entity.GenericValue;

public class ChangeEntryBuilder {
    private final StatusChangeEntryBuilder statusChangeEntryBuilder;
    private final GeneralUpdateEntryBuilder generalUpdateEntryBuilder;

    ChangeEntryBuilder(StatusChangeEntryBuilder statusChangeEntryBuilder, GeneralUpdateEntryBuilder generalUpdateEntryBuilder) {
        this.statusChangeEntryBuilder = (StatusChangeEntryBuilder)Preconditions.checkNotNull((Object)statusChangeEntryBuilder, (Object)"statusChangeEntryBuilder");
        this.generalUpdateEntryBuilder = (GeneralUpdateEntryBuilder)Preconditions.checkNotNull((Object)generalUpdateEntryBuilder, (Object)"generalUpdateEntryBuilder");
    }

    public Option<StreamsEntry> build(AggregatedJiraActivityItem aggregatedItem, ActivityRequest request) {
        URI baseUri = request.getContextUri();
        if (this.isTransitionVerb(aggregatedItem)) {
            JiraActivityItem item = aggregatedItem.getActivityItem();
            return this.statusChangeEntryBuilder.build(item, baseUri, (GenericValue)Iterables.find(ChangeItems.getChangeItems(item), ChangeItems.isStatusUpdate()));
        }
        return this.generalUpdateEntryBuilder.build(baseUri, aggregatedItem);
    }

    private boolean isTransitionVerb(AggregatedJiraActivityItem aggregatedItem) {
        if (!aggregatedItem.getRelatedActivityItems().isDefined()) {
            ActivityVerb verb = (ActivityVerb)aggregatedItem.getActivity().second();
            if (JiraActivityVerbs.transition().equals(verb)) {
                return true;
            }
            Iterator i$ = verb.parent().iterator();
            if (i$.hasNext()) {
                ActivityVerb childVerb = (ActivityVerb)i$.next();
                return JiraActivityVerbs.transition().equals(childVerb);
            }
        }
        return false;
    }
}

