/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.jira.builder;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.streams.api.ActivityObjectTypes;
import com.atlassian.streams.api.StreamsEntry;
import com.atlassian.streams.api.common.Option;
import com.atlassian.streams.jira.JiraActivityObjectTypes;
import com.atlassian.streams.jira.UriProvider;
import com.atlassian.streams.spi.StreamsUriBuilder;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Date;

public class ActivityObjectBuilder {
    private final UriProvider issueUriBuilder;

    ActivityObjectBuilder(UriProvider issueUriBuilder) {
        this.issueUriBuilder = (UriProvider)Preconditions.checkNotNull((Object)issueUriBuilder, (Object)"issueUriBuilder");
    }

    public StreamsEntry.ActivityObject build(URI baseUri, Issue issue, String issueSummary) {
        return new StreamsEntry.ActivityObject(StreamsEntry.ActivityObject.params().id(new StreamsUriBuilder().setUrl(this.issueUriBuilder.getIssueUri(baseUri, issue).toASCIIString()).getUri().toASCIIString()).activityObjectType(JiraActivityObjectTypes.issue()).title(Option.option((Object)issue.getKey())).summary(Option.some((Object)issueSummary)).alternateLinkUri(this.issueUriBuilder.getIssueUri(baseUri, issue)));
    }

    public StreamsEntry.ActivityObject build(URI baseUri, Comment comment) {
        StreamsUriBuilder idBuilder = new StreamsUriBuilder().setUrl(this.issueUriBuilder.getIssueUri(baseUri, comment.getIssue()).toASCIIString()).setTimestamp(comment.getUpdated());
        return new StreamsEntry.ActivityObject(StreamsEntry.ActivityObject.params().id(idBuilder.getUri().toASCIIString()).title(Option.none(String.class)).activityObjectType(ActivityObjectTypes.comment()).alternateLinkUri(this.issueUriBuilder.getIssueCommentUri(baseUri, comment)));
    }

    public Iterable<StreamsEntry.ActivityObject> build(URI baseUri, Iterable<Attachment> attachments) {
        return Iterables.transform(attachments, this.toAttachmentActivityObject(baseUri));
    }

    private Function<Attachment, StreamsEntry.ActivityObject> toAttachmentActivityObject(final URI baseUri) {
        return new Function<Attachment, StreamsEntry.ActivityObject>(){

            public StreamsEntry.ActivityObject apply(Attachment attachment) {
                StreamsUriBuilder idBuilder = new StreamsUriBuilder().setUrl(ActivityObjectBuilder.this.issueUriBuilder.getIssueUri(baseUri, attachment.getIssueObject()).toASCIIString()).setTimestamp((Date)attachment.getCreated());
                return new StreamsEntry.ActivityObject(StreamsEntry.ActivityObject.params().id(idBuilder.getUri().toASCIIString()).activityObjectType(ActivityObjectTypes.file()).title(Option.some((Object)attachment.getFilename())).alternateLinkUri(ActivityObjectBuilder.this.issueUriBuilder.getAttachmentUri(baseUri, attachment)));
            }
        };
    }
}

