/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.jira;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.streams.spi.StreamsKeyProvider;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;

public class ProjectKeys {
    private final JiraAuthenticationContext authenticationContext;
    private final PermissionManager permissionManager;

    public ProjectKeys(PermissionManager permissionManager, JiraAuthenticationContext authenticationContext) {
        this.permissionManager = permissionManager;
        this.authenticationContext = authenticationContext;
    }

    public Iterable<StreamsKeyProvider.StreamsKey> get() {
        return ImmutableList.builder().addAll(this.projectKeys()).build();
    }

    private Iterable<StreamsKeyProvider.StreamsKey> projectKeys() {
        return Iterables.transform((Iterable)this.permissionManager.getProjectObjects(10, this.authenticationContext.getLoggedInUser()), (Function)ToStreamsKey.INSTANCE);
    }

    static enum ToStreamsKey implements Function<Project, StreamsKeyProvider.StreamsKey>
    {
        INSTANCE;


        public StreamsKeyProvider.StreamsKey apply(Project p) {
            return new StreamsKeyProvider.StreamsKey(p.getKey(), p.getName());
        }
    }
}

