/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.jira;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.exception.AttachmentNotFoundException;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.changehistory.ChangeHistory;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.link.RemoteIssueLink;
import com.atlassian.jira.issue.link.RemoteIssueLinkManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.streams.api.ActivityObjectType;
import com.atlassian.streams.api.ActivityObjectTypes;
import com.atlassian.streams.api.ActivityVerb;
import com.atlassian.streams.api.ActivityVerbs;
import com.atlassian.streams.api.Html;
import com.atlassian.streams.api.StreamsEntry;
import com.atlassian.streams.api.UserProfile;
import com.atlassian.streams.api.common.Functions;
import com.atlassian.streams.api.common.ImmutableNonEmptyList;
import com.atlassian.streams.api.common.NonEmptyIterable;
import com.atlassian.streams.api.common.NonEmptyIterables;
import com.atlassian.streams.api.common.Option;
import com.atlassian.streams.api.common.Options;
import com.atlassian.streams.api.common.Pair;
import com.atlassian.streams.jira.ChangeItems;
import com.atlassian.streams.jira.JiraActivityItem;
import com.atlassian.streams.jira.JiraActivityObjectTypes;
import com.atlassian.streams.jira.JiraActivityVerbs;
import com.atlassian.streams.jira.UriProvider;
import com.atlassian.streams.jira.builder.ActivityObjectBuilder;
import com.atlassian.streams.jira.builder.JiraEntryBuilderFactory;
import com.atlassian.streams.spi.UserProfileAccessor;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraHelper {
    private static final Logger log = LoggerFactory.getLogger(JiraHelper.class);
    private final UriProvider uriProvider;
    private final JiraEntryBuilderFactory entryBuilderFactory;
    private final ActivityObjectBuilder activityObjectBuilder;
    private final UserProfileAccessor userProfileAccessor;
    private final AttachmentManager attachmentManager;
    private final RemoteIssueLinkManager remoteIssueLinkManager;
    private final RendererManager rendererManager;
    private final FieldLayoutManager fieldLayoutManager;
    private final ConstantsManager constantsManager;
    private final Function<GenericValue, Option<Attachment>> getAttachment = new Function<GenericValue, Option<Attachment>>(){

        public Option<Attachment> apply(GenericValue v) {
            return Option.option((Object)v.getString("newvalue")).map(Functions.parseLong()).flatMap(JiraHelper.this.lookupAttachment);
        }
    };
    private final Function<Long, Option<Attachment>> lookupAttachment = new Function<Long, Option<Attachment>>(){

        public Option<Attachment> apply(Long id) {
            try {
                return Option.option((Object)JiraHelper.this.attachmentManager.getAttachment(id));
            }
            catch (DataAccessException e) {
                log.error("Error retrieving attachments", (Throwable)e);
                return Option.none();
            }
            catch (AttachmentNotFoundException e) {
                return Option.none();
            }
        }
    };
    private final Function<GenericValue, Option<RemoteIssueLink>> getRemoteIssueLink = new Function<GenericValue, Option<RemoteIssueLink>>(){

        public Option<RemoteIssueLink> apply(GenericValue v) {
            return Option.option((Object)v.getString("newvalue")).map(Functions.parseLong()).flatMap(JiraHelper.this.lookupRemoteIssueLink);
        }
    };
    private final Function<Long, Option<RemoteIssueLink>> lookupRemoteIssueLink = new Function<Long, Option<RemoteIssueLink>>(){

        public Option<RemoteIssueLink> apply(Long id) {
            try {
                return Option.option((Object)JiraHelper.this.remoteIssueLinkManager.getRemoteIssueLink(id));
            }
            catch (DataAccessException e) {
                log.error("Error retrieving remote issue link", (Throwable)e);
                return Option.none();
            }
        }
    };
    private final Predicate<GenericValue> validAttachment = new Predicate<GenericValue>(){

        public boolean apply(GenericValue item) {
            if ("attachment".equalsIgnoreCase(item.getString("field"))) {
                try {
                    return JiraHelper.this.attachmentManager.getAttachment(NumberUtils.createLong((String)item.getString("newvalue"))) != null;
                }
                catch (Exception e) {
                    return false;
                }
            }
            return true;
        }
    };
    private final Function<Comment, Html> renderComment = new Function<Comment, Html>(){

        public Html apply(Comment comment) {
            return JiraHelper.this.renderIssueFieldValue(comment.getIssue(), "comment", comment.getBody());
        }
    };
    private final Function<Issue, Html> renderDescription = new Function<Issue, Html>(){

        public Html apply(Issue issue) {
            return JiraHelper.this.renderIssueFieldValue(issue, "description", issue.getDescription());
        }
    };

    JiraHelper(JiraEntryBuilderFactory entryBuilderFactory, UriProvider uriProvider, ActivityObjectBuilder activityObjectBuilder, UserProfileAccessor userProfileAccessor, AttachmentManager attachmentManager, RemoteIssueLinkManager remoteIssueLinkManager, RendererManager rendererManager, FieldLayoutManager fieldLayoutManager, ConstantsManager constantsManager) {
        this.fieldLayoutManager = fieldLayoutManager;
        this.entryBuilderFactory = (JiraEntryBuilderFactory)Preconditions.checkNotNull((Object)entryBuilderFactory, (Object)"entryBuilderFactory");
        this.uriProvider = (UriProvider)Preconditions.checkNotNull((Object)uriProvider, (Object)"uriProvider");
        this.activityObjectBuilder = (ActivityObjectBuilder)Preconditions.checkNotNull((Object)activityObjectBuilder, (Object)"activityObjectBuilder");
        this.userProfileAccessor = (UserProfileAccessor)Preconditions.checkNotNull((Object)userProfileAccessor, (Object)"userProfileAccessor");
        this.attachmentManager = (AttachmentManager)Preconditions.checkNotNull((Object)attachmentManager, (Object)"attachmentManager");
        this.remoteIssueLinkManager = (RemoteIssueLinkManager)Preconditions.checkNotNull((Object)remoteIssueLinkManager, (Object)"remoteIssueLinkManager");
        this.rendererManager = (RendererManager)Preconditions.checkNotNull((Object)rendererManager, (Object)"rendererManager");
        this.constantsManager = (ConstantsManager)Preconditions.checkNotNull((Object)constantsManager, (Object)"constantsManager");
    }

    public StreamsEntry.Parameters<StreamsEntry.HasId, StreamsEntry.HasPostedDate, StreamsEntry.HasAlternateLinkUri, StreamsEntry.HasApplicationType, StreamsEntry.NeedsRenderer, StreamsEntry.NeedsVerb, StreamsEntry.NeedsAuthors> newBuilder(JiraActivityItem item, URI requestUri) {
        return this.entryBuilderFactory.newParams(item, this.getIssueUri(requestUri, item), requestUri);
    }

    public StreamsEntry.Parameters<StreamsEntry.HasId, StreamsEntry.HasPostedDate, StreamsEntry.HasAlternateLinkUri, StreamsEntry.HasApplicationType, StreamsEntry.NeedsRenderer, StreamsEntry.NeedsVerb, StreamsEntry.NeedsAuthors> newCommentBuilder(URI baseUri, JiraActivityItem item) {
        return this.entryBuilderFactory.newParams(item, this.uriProvider.getIssueCommentUri(baseUri, (Comment)item.getComment().get()), baseUri);
    }

    public StreamsEntry.Parameters<StreamsEntry.HasId, StreamsEntry.HasPostedDate, StreamsEntry.HasAlternateLinkUri, StreamsEntry.HasApplicationType, StreamsEntry.NeedsRenderer, StreamsEntry.NeedsVerb, StreamsEntry.NeedsAuthors> newLinkedIssueBuilder(URI baseUri, JiraActivityItem item) {
        return this.entryBuilderFactory.newLinkedIssueParams(item, this.getIssueUri(baseUri, item), baseUri);
    }

    public URI getIssueUri(URI baseUri, JiraActivityItem activityItem) {
        return this.getIssueUri(baseUri, activityItem.getIssue());
    }

    URI getIssueUri(URI baseUri, Issue issue) {
        return this.getIssueUri(baseUri, issue.getKey());
    }

    URI getIssueUri(URI baseUri, String issueKey) {
        return this.uriProvider.getIssueUri(baseUri, issueKey);
    }

    public StreamsEntry.ActivityObject buildActivityObject(URI baseUri, Comment comment) {
        return this.activityObjectBuilder.build(baseUri, comment);
    }

    public StreamsEntry.ActivityObject buildActivityObject(Issue issue, URI baseUri, String issueSummary) {
        return this.activityObjectBuilder.build(baseUri, issue, issueSummary);
    }

    public Iterable<StreamsEntry.ActivityObject> buildActivityObjects(URI baseUri, Iterable<Attachment> attachments) {
        return this.activityObjectBuilder.build(baseUri, attachments);
    }

    public Function<String, UserProfile> getUserProfile(final URI baseUri) {
        return new Function<String, UserProfile>(){

            public UserProfile apply(@Nullable String username) {
                return JiraHelper.this.userProfileAccessor.getUserProfile(baseUri, username);
            }
        };
    }

    public NonEmptyIterable<UserProfile> getUserProfiles(URI baseUri, Iterable<String> usernames) {
        return (NonEmptyIterable)NonEmptyIterables.from((Iterable)Iterables.transform(usernames, this.getUserProfile(baseUri))).getOrElse((Object)ImmutableNonEmptyList.of((Object)this.userProfileAccessor.getAnonymousUserProfile(baseUri)));
    }

    public Iterable<Attachment> extractAttachments(Iterable<GenericValue> changeItems) {
        return Options.catOptions((Iterable)Iterables.transform((Iterable)Iterables.filter(changeItems, ChangeItems.isAttachment()), this.getAttachment()));
    }

    public static String getNameFor(ApplicationUser appUser) {
        return appUser == null ? null : appUser.getUsername();
    }

    private Function<GenericValue, Option<Attachment>> getAttachment() {
        return this.getAttachment;
    }

    public Option<RemoteIssueLink> extractRemoteIssueLink(Iterable<GenericValue> changeItems) {
        return Options.find((Iterable)Iterables.transform((Iterable)Iterables.filter(changeItems, ChangeItems.isRemoteLinkUpdate()), this.getRemoteIssueLink()));
    }

    private Function<GenericValue, Option<RemoteIssueLink>> getRemoteIssueLink() {
        return this.getRemoteIssueLink;
    }

    public Option<Pair<ActivityObjectType, ActivityVerb>> jiraActivity(ChangeHistory history) {
        try {
            GenericValue changeItem = (GenericValue)Iterables.find(ChangeItems.getChangeItems(history), (Predicate)Predicates.or(ChangeItems.isStatusUpdate(), ChangeItems.isDeletedComment()));
            if (ChangeItems.isStatusUpdate(changeItem)) {
                return Option.some((Object)Pair.pair((Object)JiraActivityObjectTypes.issue(), (Object)this.getTransitionVerb(changeItem)));
            }
            return Option.none();
        }
        catch (NoSuchElementException e) {
            Iterable changeItems = Iterables.filter(ChangeItems.getChangeItems(history), this.validAttachment);
            if (Iterables.isEmpty((Iterable)changeItems)) {
                return Option.none();
            }
            if (ChangeItems.updatedFieldCount(changeItems) == 1 && ChangeItems.isAttachment((GenericValue)Iterables.get((Iterable)changeItems, (int)0))) {
                return Option.some((Object)Pair.pair((Object)ActivityObjectTypes.file(), (Object)ActivityVerbs.post()));
            }
            if (ChangeItems.updatedFieldCount(changeItems) == 1 && ChangeItems.isRemoteLinkUpdate((GenericValue)Iterables.get((Iterable)changeItems, (int)0))) {
                return Option.some((Object)Pair.pair((Object)JiraActivityObjectTypes.issue(), (Object)JiraActivityVerbs.remoteLink()));
            }
            return Option.some((Object)Pair.pair((Object)JiraActivityObjectTypes.issue(), (Object)ActivityVerbs.update()));
        }
    }

    private ActivityVerb getTransitionVerb(GenericValue changeItem) {
        int oldStatusId = NumberUtils.toInt((String)changeItem.getString("oldvalue"), (int)-1);
        String newStatusIdString = changeItem.getString("newvalue");
        int newStatusId = NumberUtils.toInt((String)newStatusIdString, (int)-1);
        switch (newStatusId) {
            case 5: {
                return JiraActivityVerbs.resolve();
            }
            case 6: {
                return JiraActivityVerbs.close();
            }
            case 4: {
                return JiraActivityVerbs.reopen();
            }
            case 1: {
                if (oldStatusId == 3) {
                    return JiraActivityVerbs.stop();
                }
                return JiraActivityVerbs.open();
            }
            case 3: {
                return JiraActivityVerbs.start();
            }
        }
        return JiraActivityVerbs.transition();
    }

    public Predicate<GenericValue> validAttachment() {
        return this.validAttachment;
    }

    public Function<Comment, Html> renderComment() {
        return this.renderComment;
    }

    public Function<String, Html> renderCommentString(final Issue issue) {
        return new Function<String, Html>(){

            public Html apply(String comment) {
                return JiraHelper.this.renderIssueFieldValue(issue, "comment", comment);
            }
        };
    }

    public Function<Issue, Html> renderDescription() {
        return this.renderDescription;
    }

    public Html renderIssueFieldValue(Issue issue, String fieldId, String value) {
        FieldLayoutItem fieldLayoutItem = this.fieldLayoutManager.getFieldLayout(issue.getProjectObject(), issue.getIssueTypeObject().getId()).getFieldLayoutItem(fieldId);
        if (fieldLayoutItem == null) {
            return new Html(value);
        }
        return new Html(this.rendererManager.getRenderedContent(fieldLayoutItem.getRendererType(), value, issue.getIssueRenderContext()));
    }

    public Option<String> getNewChangeItemNameTranslation(GenericValue changeItem) {
        if (changeItem == null) {
            return Option.none(String.class);
        }
        String field = changeItem.getString("field");
        String newValue = changeItem.getString("newvalue");
        String newString = changeItem.getString("newstring");
        return this.getChangeItemNameTranslation(field, newValue, newString);
    }

    public Option<String> getOldChangeItemNameTranslation(GenericValue changeItem) {
        if (changeItem == null) {
            return Option.none(String.class);
        }
        String field = changeItem.getString("field");
        String oldValue = changeItem.getString("oldvalue");
        String oldString = changeItem.getString("oldstring");
        return this.getChangeItemNameTranslation(field, oldValue, oldString);
    }

    private Option<String> getChangeItemNameTranslation(String field, String value, String str) {
        if (StringUtils.isNotBlank((String)value) && StringUtils.isNotBlank((String)field)) {
            IssueConstant issueConstant = this.constantsManager.getConstantObject(field, value);
            if (issueConstant != null) {
                return Option.some((Object)issueConstant.getNameTranslation());
            }
            if (str != null) {
                return Option.some((Object)str);
            }
            return Option.none(String.class);
        }
        if (StringUtils.isNotBlank((String)str)) {
            return Option.some((Object)str);
        }
        return Option.none(String.class);
    }

    public static String getNameFor(User user) {
        return user == null ? null : user.getName();
    }
}

