/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.jira;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.changehistory.ChangeHistory;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.streams.api.ActivityObjectType;
import com.atlassian.streams.api.ActivityVerb;
import com.atlassian.streams.api.common.Option;
import com.atlassian.streams.api.common.Pair;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Date;

public class JiraActivityItem {
    private final Issue issue;
    private final String displaySummary;
    private final Option<String> initialDescription;
    private final Option<ChangeHistory> changeHistory;
    private final Option<Comment> comment;
    private final Date date;
    private final Pair<ActivityObjectType, ActivityVerb> activity;
    static final Predicate<ChangeHistory> HAS_AUTHOR = new Predicate<ChangeHistory>(){

        public boolean apply(ChangeHistory input) {
            return input.getAuthorUser() != null;
        }
    };
    static final Function<ChangeHistory, String> USER_NAME = new Function<ChangeHistory, String>(){

        public String apply(ChangeHistory from) {
            return from.getAuthorUser().getName();
        }
    };

    public JiraActivityItem(Issue issue, String displaySummary, Pair<ActivityObjectType, ActivityVerb> activity, Option<String> initialDescription) {
        this.issue = (Issue)Preconditions.checkNotNull((Object)issue, (Object)"issue");
        this.displaySummary = (String)Preconditions.checkNotNull((Object)displaySummary, (Object)"initialSummary");
        this.activity = (Pair)Preconditions.checkNotNull(activity, (Object)"activity");
        this.initialDescription = (Option)Preconditions.checkNotNull(initialDescription, (Object)"initialDescription");
        this.comment = Option.none();
        this.changeHistory = Option.none();
        this.date = issue.getCreated();
    }

    public JiraActivityItem(Issue issue, String displaySummary, Pair<ActivityObjectType, ActivityVerb> activity, Comment comment) {
        this.issue = (Issue)Preconditions.checkNotNull((Object)issue, (Object)"issue");
        this.displaySummary = (String)Preconditions.checkNotNull((Object)displaySummary, (Object)"initialSummary");
        this.activity = (Pair)Preconditions.checkNotNull(activity, (Object)"activity");
        this.comment = Option.some((Object)Preconditions.checkNotNull((Object)comment, (Object)"comment"));
        this.changeHistory = Option.none();
        this.date = comment.getCreated();
        this.initialDescription = Option.none();
    }

    public JiraActivityItem(Issue issue, String displaySummary, Pair<ActivityObjectType, ActivityVerb> activity, Comment comment, ChangeHistory changeHistory) {
        this.issue = (Issue)Preconditions.checkNotNull((Object)issue, (Object)"issue");
        this.displaySummary = (String)Preconditions.checkNotNull((Object)displaySummary, (Object)"initialSummary");
        this.activity = (Pair)Preconditions.checkNotNull(activity, (Object)"activity");
        this.changeHistory = Option.some((Object)Preconditions.checkNotNull((Object)changeHistory, (Object)"changeHistory"));
        this.comment = Option.some((Object)Preconditions.checkNotNull((Object)comment, (Object)"comment"));
        this.date = changeHistory.getTimePerformed();
        this.initialDescription = Option.none();
    }

    public JiraActivityItem(Issue issue, String displaySummary, Pair<ActivityObjectType, ActivityVerb> activity, ChangeHistory changeHistory) {
        this.issue = (Issue)Preconditions.checkNotNull((Object)issue, (Object)"issue");
        this.displaySummary = (String)Preconditions.checkNotNull((Object)displaySummary, (Object)"initialSummary");
        this.activity = (Pair)Preconditions.checkNotNull(activity, (Object)"activity");
        this.changeHistory = Option.some((Object)Preconditions.checkNotNull((Object)changeHistory, (Object)"changeHistory"));
        this.comment = Option.none();
        this.date = changeHistory.getTimePerformed();
        this.initialDescription = Option.none();
    }

    public Issue getIssue() {
        return this.issue;
    }

    public String getDisplaySummary() {
        return this.displaySummary;
    }

    public Option<String> getInitialDescription() {
        return this.initialDescription;
    }

    public Option<ChangeHistory> getChangeHistory() {
        return this.changeHistory;
    }

    public Iterable<String> getChangeHistoryAuthors() {
        return Iterables.transform((Iterable)Iterables.filter(this.getChangeHistory(), HAS_AUTHOR), USER_NAME);
    }

    public Option<Comment> getComment() {
        return this.comment;
    }

    public Date getDate() {
        return this.date;
    }

    public Pair<ActivityObjectType, ActivityVerb> getActivity() {
        return this.activity;
    }

    public String toString() {
        return this.issue.getKey();
    }
}

