/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.action;

import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.transformer.CharSequenceDownloadableResource;
import com.atlassian.plugin.webresource.transformer.WebResourceTransformer;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.streams.spi.StreamsLocaleProvider;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.dom4j.Element;

public class ActionHandlerI18nTransformer
implements WebResourceTransformer {
    private static final String SUFFIX = ".i18n.js";
    private final I18nResolver i18nResolver;
    private final StreamsLocaleProvider localeProvider;

    public ActionHandlerI18nTransformer(I18nResolver i18nResolver, StreamsLocaleProvider localeProvider) {
        this.i18nResolver = (I18nResolver)Preconditions.checkNotNull((Object)i18nResolver, (Object)"i18nResolver");
        this.localeProvider = (StreamsLocaleProvider)Preconditions.checkNotNull((Object)localeProvider, (Object)"localeProvider");
    }

    public DownloadableResource transform(Element configElement, final ResourceLocation location, String filePath, DownloadableResource nextResource) {
        return new CharSequenceDownloadableResource(nextResource){

            protected String transform(CharSequence originalContent) {
                int suffixIndex = location.getName().indexOf(ActionHandlerI18nTransformer.SUFFIX);
                if (suffixIndex == -1) {
                    return ((Object)originalContent).toString();
                }
                return ActionHandlerI18nTransformer.this.getI18nContents(location.getName().substring(0, suffixIndex)) + originalContent;
            }
        };
    }

    private String getI18nContents(String prefix) {
        Map translations = this.i18nResolver.getAllTranslationsForPrefix(prefix, this.localeProvider.getUserLocale());
        StringBuilder contents = new StringBuilder();
        for (String key : translations.keySet()) {
            contents.append("ActivityStreams.i18n.put('").append(key).append("', '").append(StringEscapeUtils.escapeJavaScript((String)((String)translations.get(key)))).append("');\n");
        }
        return contents.toString();
    }
}

