/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.testing.matchers;

import com.atlassian.streams.api.StreamsEntry;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.abdera.ext.thread.InReplyTo;
import org.apache.abdera.model.Category;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.ExtensibleElement;
import org.apache.abdera.model.Link;
import org.apache.abdera.model.Person;
import org.apache.abdera.model.Text;
import org.apache.abdera.parser.stax.FOMGenerator;
import org.apache.abdera.util.Constants;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.hamcrest.TypeSafeMatcher;
import org.joda.time.DateTime;

public abstract class Matchers {
    private static final Predicate<Element> linkPredicate = new Predicate<Element>(){

        public boolean apply(Element element) {
            return element instanceof Link;
        }
    };

    public static Matcher<Iterable<? extends Entry>> hasNoEntries() {
        return org.hamcrest.Matchers.emptyIterable();
    }

    public static Matcher<Iterable<Entry>> allEntries(Matcher<Entry> matchers) {
        return org.hamcrest.Matchers.everyItem(matchers);
    }

    public static Matcher<? super Iterable<? super Entry>> hasEntry(Matcher<? super Entry> matcher) {
        return org.hamcrest.Matchers.hasItem(matcher);
    }

    public static Matcher<? super Iterable<? super Entry>> hasEntry(Matcher<? super Entry> m1, Matcher<? super Entry> m2) {
        return org.hamcrest.Matchers.hasItem((Matcher)org.hamcrest.Matchers.allOf(m1, m2));
    }

    public static Matcher<? super Iterable<? super Entry>> hasEntry(Matcher<? super Entry> m1, Matcher<? super Entry> m2, Matcher<? super Entry> m3) {
        return org.hamcrest.Matchers.hasItem((Matcher)org.hamcrest.Matchers.allOf(m1, m2, m3));
    }

    public static Matcher<? super Iterable<? super Entry>> hasEntry(Matcher<? super Entry> ... matchers) {
        return org.hamcrest.Matchers.hasItem((Matcher)org.hamcrest.Matchers.allOf(matchers));
    }

    public static Matcher<Iterable<? extends Entry>> hasEntries(Matcher<? super Entry> m) {
        return Matchers.hasEntries((List<Matcher<? super Entry>>)ImmutableList.of(m));
    }

    public static Matcher<Iterable<? extends Entry>> hasEntries(Matcher<? super Entry> m1, Matcher<? super Entry> m2) {
        return Matchers.hasEntries((List<Matcher<? super Entry>>)ImmutableList.of(m1, m2));
    }

    public static Matcher<Iterable<? extends Entry>> hasEntries(Matcher<? super Entry> m1, Matcher<? super Entry> m2, Matcher<? super Entry> m3) {
        return Matchers.hasEntries((List<Matcher<? super Entry>>)ImmutableList.of(m1, m2, m3));
    }

    public static Matcher<Iterable<? extends Entry>> hasEntries(Matcher<? super Entry> m1, Matcher<? super Entry> m2, Matcher<? super Entry> m3, Matcher<? super Entry> m4) {
        return Matchers.hasEntries((List<Matcher<? super Entry>>)ImmutableList.of(m1, m2, m3, m4));
    }

    public static Matcher<Iterable<? extends Entry>> hasEntries(Matcher<? super Entry> ... matchers) {
        return Matchers.hasEntries(Arrays.asList(matchers));
    }

    public static Matcher<Iterable<? extends Entry>> hasEntries(List<Matcher<? super Entry>> matchers) {
        return org.hamcrest.Matchers.contains(matchers);
    }

    public static Matcher<Iterable<? extends Element>> hasElements(Matcher<? super Element> matcher) {
        return Matchers.hasElements((List<Matcher<? super Element>>)ImmutableList.of(matcher));
    }

    public static Matcher<Iterable<? extends Element>> hasElements(Matcher<? super Element> m1, Matcher<? super Element> m2) {
        return Matchers.hasElements((List<Matcher<? super Element>>)ImmutableList.of(m1, m2));
    }

    public static Matcher<Iterable<? extends Element>> hasElements(Matcher<? super Element> m1, Matcher<? super Element> m2, Matcher<? super Element> m3) {
        return Matchers.hasElements((List<Matcher<? super Element>>)ImmutableList.of(m1, m2, m3));
    }

    public static Matcher<Iterable<? extends Entry>> hasEntriesInAnyOrder(List<Matcher<? super Entry>> matchers) {
        return org.hamcrest.Matchers.containsInAnyOrder(matchers);
    }

    public static Matcher<Iterable<? extends Element>> hasElements(Matcher<? super Element> ... matchers) {
        return Matchers.hasElements((List<Matcher<? super Element>>)ImmutableList.copyOf((Object[])matchers));
    }

    public static Matcher<Iterable<? extends Element>> hasElements(List<Matcher<? super Element>> matchers) {
        return org.hamcrest.Matchers.contains(matchers);
    }

    public static Matcher<Iterable<? extends ExtensibleElement>> hasActivityObjects(Matcher<? super ExtensibleElement> matcher) {
        return Matchers.hasActivityObjects((List<Matcher<? super ExtensibleElement>>)ImmutableList.of(matcher));
    }

    public static Matcher<Iterable<? extends ExtensibleElement>> hasActivityObjects(Matcher<? super ExtensibleElement> m1, Matcher<? super ExtensibleElement> m2) {
        return Matchers.hasActivityObjects((List<Matcher<? super ExtensibleElement>>)ImmutableList.of(m1, m2));
    }

    public static Matcher<Iterable<? extends ExtensibleElement>> hasActivityObjects(Matcher<? super ExtensibleElement> m1, Matcher<? super ExtensibleElement> m2, Matcher<? super ExtensibleElement> m3) {
        return Matchers.hasActivityObjects((List<Matcher<? super ExtensibleElement>>)ImmutableList.of(m1, m2, m3));
    }

    public static Matcher<Iterable<? extends ExtensibleElement>> hasActivityObjects(Matcher<? super ExtensibleElement> ... matchers) {
        return Matchers.hasActivityObjects((List<Matcher<? super ExtensibleElement>>)ImmutableList.copyOf((Object[])matchers));
    }

    public static Matcher<Iterable<? extends ExtensibleElement>> hasActivityObjects(List<Matcher<? super ExtensibleElement>> matchers) {
        return org.hamcrest.Matchers.contains(matchers);
    }

    public static Matcher<Entry> hasTarget(Matcher<? super ExtensibleElement> matcher) {
        return new HasTarget(matcher);
    }

    public static Matcher<Entry> withPublishedDate(Matcher<? super DateTime> matcher) {
        return new WithPublishedDate(matcher);
    }

    public static Matcher<Entry> withTitle(Matcher<? super String> matcher) {
        return new WithTitle(matcher);
    }

    public static Matcher<Entry> withHtmlTitle(Matcher<? super String> matcher) {
        return org.hamcrest.Matchers.allOf((Matcher)new IsTitleHtml(), (Matcher)new WithTitle(matcher));
    }

    public static Matcher<Entry> withCategory(Matcher<Category> matcher) {
        return new WithCategory(matcher);
    }

    public static Matcher<Category> withTerm(Matcher<? super String> matcher) {
        return new WithTerm(matcher);
    }

    public static Matcher<Entry> hasAuthor(Matcher<Element> matcher) {
        return new HasAuthor(matcher);
    }

    public static Matcher<Element> withLink(Matcher<Link> matcher) {
        return new WithLink(matcher);
    }

    public static Matcher<Link> whereRel(Matcher<? super String> matcher) {
        return new WhereRel(matcher);
    }

    public static Matcher<Link> whereHref(Matcher<? super String> matcher) {
        return new WhereHref(matcher);
    }

    public static Matcher<? super Element> withText(Matcher<? super String> matcher) {
        return new WithText(matcher);
    }

    public static Matcher<? super ExtensibleElement> withId(Matcher<? super String> matcher) {
        return new WithId(matcher);
    }

    public static Matcher<? super ExtensibleElement> withType(Matcher<? super String> matcher) {
        return new WithType(matcher);
    }

    public static Matcher<? super Entry> withSummary(Matcher<? super String> matcher) {
        return new WithSummary(matcher);
    }

    public static Matcher<Entry> withEmptyContent() {
        return new WithEmptyContent();
    }

    public static Matcher<Entry> withContent(Matcher<? super String> matcher) {
        return new WithContent(matcher);
    }

    public static Matcher<Entry> withUpdatedDate(Matcher<? super Date> matcher) {
        return new WithUpdatedDate(matcher);
    }

    public static Matcher<Entry> haveAtomSourceElement() {
        return new HaveAtomSourceElement();
    }

    public static Matcher<Entry> haveAtlassianApplicationElement(Matcher<? super String> matcher) {
        return new HaveAtlassianApplicationElement(matcher);
    }

    public static Matcher<Entry> haveAtomGeneratorElement(Matcher<String> matcher) {
        return new HaveAtomGeneratorElement(matcher);
    }

    private static FOMGenerator getAtomGeneratorUri(Entry entry) {
        return (FOMGenerator)entry.getExtension(Constants.GENERATOR);
    }

    public static Matcher<Entry> haveLink(Matcher<Link> matcher) {
        return new EntryLinkMatcher(matcher);
    }

    public static Matcher<Iterable<? super Link>> hasLink(Matcher<Link> m1, Matcher<Link> m2) {
        return Matchers.hasLink((Iterable<Matcher<? super Link>>)ImmutableList.of(m1, m2));
    }

    public static Matcher<Iterable<? super Link>> hasLink(Iterable<Matcher<? super Link>> matchers) {
        return org.hamcrest.Matchers.hasItem((Matcher)org.hamcrest.Matchers.allOf(matchers));
    }

    public static Matcher<? super Entry> withAuthorElement(Matcher<? super String> matcher) {
        return new WithAuthorElement(matcher);
    }

    public static Matcher<? super Entry> withAuthorLink(Matcher<Link> matcher) {
        return new WithAuthorLink(matcher);
    }

    public static Matcher<Entry> withVerbElement(Matcher<? super String> matcher) {
        return new WithVerbElement(matcher);
    }

    public static Matcher<Entry> withActivityObjectElement(Matcher<? super ExtensibleElement> matcher) {
        return new WithActivityObjectElement(matcher);
    }

    public static Matcher<? super Entry> withInReplyToElement(Matcher<? super String> matcher) {
        return new WithInReplyToElement(matcher);
    }

    private static String getInReplyToRef(Entry entry) {
        InReplyTo inReplyTo = (InReplyTo)entry.getExtension(AtomConstants.IN_REPLY_TO);
        if (inReplyTo != null && inReplyTo.getRef() != null) {
            return inReplyTo.getRef().toASCIIString();
        }
        return null;
    }

    public static Matcher<Iterable<Entry>> inDescendingOrder() {
        return new InDescendingOrder();
    }

    public static Matcher<Iterable<Entry>> hasEntryCount(Matcher<? super Integer> matcher) {
        return new EntryCount(matcher);
    }

    public static Matcher<Iterable<? super StreamsEntry.Link>> hasStreamsLink(Matcher<? super StreamsEntry.Link> matcher) {
        return org.hamcrest.Matchers.hasItem(matcher);
    }

    public static Matcher<StreamsEntry.Link> whereStreamsRel(Matcher<? super String> matcher) {
        return new WhereStreamsRel(matcher);
    }

    public static Matcher<? super String> matchesRegEx(String regex) {
        return new RegexpMatcher(regex);
    }

    static final class AtomConstants {
        public static final String ACTIVITY_PREFIX = "activity";
        public static final String ATLASSIAN_PREFIX = "atlassian";
        public static final String USR_PREFIX = "usr";
        public static final String THR_PREFIX = "thr";
        public static final String ACTIVITY_NS = "http://activitystrea.ms/spec/1.0/";
        public static final String ATLASSIAN_NS = "http://streams.atlassian.com/syndication/general/1.0";
        public static final String USR_NS = "http://streams.atlassian.com/syndication/username/1.0";
        public static final String THR_NS = "http://purl.org/syndication/thread/1.0";
        public static final String LN_OBJECT = "object";
        public static final String LN_OBJECT_TYPE = "object-type";
        public static final String LN_TARGET = "target";
        public static final String LN_VERB = "verb";
        public static final String LN_APPLICATION = "application";
        public static final String LN_USERNAME = "username";
        public static final String LN_INREPLYTO = "in-reply-to";
        public static final QName ACTIVITY_VERB = new QName("http://activitystrea.ms/spec/1.0/", "verb", "activity");
        public static final QName ACTIVITY_OBJECT = new QName("http://activitystrea.ms/spec/1.0/", "object", "activity");
        public static final QName ACTIVITY_TARGET = new QName("http://activitystrea.ms/spec/1.0/", "target", "activity");
        public static final QName ACTIVITY_OBJECT_TYPE = new QName("http://activitystrea.ms/spec/1.0/", "object-type", "activity");
        public static final QName ATLASSIAN_APPLICATION = new QName("http://streams.atlassian.com/syndication/general/1.0", "application", "atlassian");
        public static final QName USR_USERNAME = new QName("http://streams.atlassian.com/syndication/username/1.0", "username", "usr");
        public static final QName IN_REPLY_TO = new QName("http://purl.org/syndication/thread/1.0", "in-reply-to", "thr");

        AtomConstants() {
        }
    }

    private static final class RegexpMatcher
    extends TypeSafeMatcher<String> {
        private final String regexp;

        private RegexpMatcher(String regexp) {
            this.regexp = regexp;
        }

        protected boolean matchesSafely(String s) {
            return s != null && s.matches(this.regexp);
        }

        public void describeTo(Description description) {
            description.appendText("matches='" + this.regexp + "'");
        }
    }

    private static final class WhereStreamsRel
    extends TypeSafeDiagnosingMatcher<StreamsEntry.Link> {
        private final Matcher<? super String> matcher;

        public WhereStreamsRel(Matcher<? super String> matcher) {
            this.matcher = matcher;
        }

        protected boolean matchesSafely(StreamsEntry.Link link, Description mismatchDescription) {
            if (link == null) {
                mismatchDescription.appendText("no link");
                return false;
            }
            if (!this.matcher.matches((Object)link.getRel())) {
                mismatchDescription.appendText("rel ");
                this.matcher.describeMismatch((Object)link.getRel(), mismatchDescription);
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText("rel ").appendDescriptionOf(this.matcher);
        }
    }

    private static final class EntryCount
    extends TypeSafeDiagnosingMatcher<Iterable<Entry>> {
        private final Matcher<? super Integer> matcher;

        public EntryCount(Matcher<? super Integer> matcher) {
            this.matcher = matcher;
        }

        protected boolean matchesSafely(Iterable<Entry> entries, Description mismatchDescription) {
            int size = Iterables.size(entries);
            if (!this.matcher.matches((Object)size)) {
                mismatchDescription.appendText("entries count ");
                this.matcher.describeMismatch((Object)size, mismatchDescription);
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText("entries count is ").appendDescriptionOf(this.matcher);
        }
    }

    private static final class InDescendingOrder
    extends TypeSafeDiagnosingMatcher<Iterable<Entry>> {
        private static Ordering<Entry> descending = new Ordering<Entry>(){

            public int compare(Entry entry1, Entry entry2) {
                return entry2.getPublished().compareTo(entry1.getPublished());
            }
        };

        private InDescendingOrder() {
        }

        protected boolean matchesSafely(Iterable<Entry> entries, Description mismatchDescription) {
            if (!descending.isOrdered(entries)) {
                mismatchDescription.appendText("was ").appendValueList("[", ", ", "]", entries);
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText("dates sorted in descending order");
        }
    }

    private static final class WithInReplyToElement
    extends TypeSafeDiagnosingMatcher<Entry> {
        private final Matcher<? super String> matcher;

        private WithInReplyToElement(Matcher<? super String> matcher) {
            this.matcher = matcher;
        }

        protected boolean matchesSafely(Entry entry, Description mismatchDescription) {
            String inReplyTo = Matchers.getInReplyToRef(entry);
            if (!this.matcher.matches((Object)inReplyTo)) {
                mismatchDescription.appendText("in-reply-to ");
                this.matcher.describeMismatch((Object)inReplyTo, mismatchDescription);
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText("in-reply-to is ").appendDescriptionOf(this.matcher);
        }
    }

    private static final class WithActivityObjectElement
    extends TypeSafeDiagnosingMatcher<Entry> {
        private final Matcher<? super ExtensibleElement> matcher;

        private WithActivityObjectElement(Matcher<? super ExtensibleElement> matcher) {
            this.matcher = matcher;
        }

        protected boolean matchesSafely(Entry entry, Description mismatchDescription) {
            List activityObjects = entry.getExtensions(AtomConstants.ACTIVITY_OBJECT);
            for (ExtensibleElement activityObject : activityObjects) {
                if (this.matcher.matches((Object)activityObject)) {
                    return true;
                }
                mismatchDescription.appendText("activity:object ");
                this.matcher.describeMismatch((Object)activityObject, mismatchDescription);
            }
            return false;
        }

        public void describeTo(Description description) {
            description.appendText("activity:object ").appendDescriptionOf(this.matcher);
        }
    }

    private static final class WithVerbElement
    extends TypeSafeDiagnosingMatcher<Entry> {
        private final Matcher<? super String> matcher;

        private WithVerbElement(Matcher<? super String> matcher) {
            this.matcher = matcher;
        }

        protected boolean matchesSafely(Entry entry, Description mismatchDescription) {
            List verbs = entry.getExtensions(AtomConstants.ACTIVITY_VERB);
            for (Element verb : verbs) {
                if (this.matcher.matches((Object)verb.getText())) {
                    return true;
                }
                mismatchDescription.appendText("activity:verb ");
                this.matcher.describeMismatch((Object)verb.getText(), mismatchDescription);
            }
            return false;
        }

        public void describeTo(Description description) {
            description.appendText("activity:verb is ").appendDescriptionOf(this.matcher);
        }
    }

    private static final class WithAuthorLink
    extends TypeSafeDiagnosingMatcher<Entry> {
        private final Matcher<Link> matcher;

        private WithAuthorLink(Matcher<Link> matcher) {
            this.matcher = matcher;
        }

        protected boolean matchesSafely(Entry entry, Description mismatchDescription) {
            List people = entry.getAuthors();
            for (Person person : people) {
                Collection linkElements = Collections2.filter((Collection)person.getElements(), (Predicate)linkPredicate);
                for (Element linkElement : linkElements) {
                    Link link = (Link)linkElement;
                    if (!this.matcher.matches((Object)link)) continue;
                    return true;
                }
            }
            mismatchDescription.appendText("link ");
            return false;
        }

        public void describeTo(Description description) {
            description.appendText("user link is ").appendDescriptionOf(this.matcher);
        }
    }

    private static final class WithAuthorElement
    extends TypeSafeDiagnosingMatcher<Entry> {
        private final Matcher<? super String> matcher;

        private WithAuthorElement(Matcher<? super String> matcher) {
            this.matcher = matcher;
        }

        protected boolean matchesSafely(Entry entry, Description mismatchDescription) {
            List people = entry.getAuthors();
            for (Person person : people) {
                if (this.matcher.matches((Object)person.getSimpleExtension(AtomConstants.USR_USERNAME))) {
                    return true;
                }
                mismatchDescription.appendText("user ");
                this.matcher.describeMismatch((Object)person.getSimpleExtension(AtomConstants.USR_USERNAME), mismatchDescription);
            }
            return false;
        }

        public void describeTo(Description description) {
            description.appendText("user is ").appendDescriptionOf(this.matcher);
        }
    }

    private static final class EntryLinkMatcher
    extends TypeSafeDiagnosingMatcher<Entry> {
        private final Matcher<Link> matcher;
        private final Predicate<Link> matches = new Predicate<Link>(){

            public boolean apply(Link l) {
                return matcher.matches((Object)l);
            }
        };

        public EntryLinkMatcher(Matcher<Link> matcher) {
            this.matcher = matcher;
        }

        public void describeTo(Description description) {
            description.appendText("entry has link ").appendDescriptionOf(this.matcher);
        }

        protected boolean matchesSafely(Entry entry, Description mismatchDescription) {
            if (Iterables.any((Iterable)entry.getLinks(), this.matches)) {
                return true;
            }
            mismatchDescription.appendText("entry has no links matching ").appendDescriptionOf(this.matcher);
            return false;
        }
    }

    private static final class HaveAtomGeneratorElement
    extends TypeSafeDiagnosingMatcher<Entry> {
        private final Matcher<String> matcher;

        private HaveAtomGeneratorElement(Matcher<String> matcher) {
            this.matcher = matcher;
        }

        protected boolean matchesSafely(Entry entry, Description mismatchDescription) {
            String generatorUri = Matchers.getAtomGeneratorUri(entry).getUri().toASCIIString();
            if (!this.matcher.matches((Object)generatorUri)) {
                mismatchDescription.appendText("does not contain a generator element with value of ");
                this.matcher.describeMismatch((Object)generatorUri, mismatchDescription);
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText("contains a generator element with value of ").appendDescriptionOf(this.matcher);
        }
    }

    private static final class HaveAtlassianApplicationElement
    extends TypeSafeDiagnosingMatcher<Entry> {
        private final Matcher<? super String> matcher;

        private HaveAtlassianApplicationElement(Matcher<? super String> matcher) {
            this.matcher = matcher;
        }

        protected boolean matchesSafely(Entry entry, Description mismatchDescription) {
            String appType = entry.getSimpleExtension(AtomConstants.ATLASSIAN_APPLICATION);
            if (appType == null) {
                mismatchDescription.appendText("no atlassian:application element");
                return false;
            }
            if (!this.matcher.matches((Object)appType)) {
                mismatchDescription.appendText("atlassian:application element ");
                this.matcher.describeMismatch((Object)appType, mismatchDescription);
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText("an atlassian:application element with ").appendDescriptionOf(this.matcher);
        }
    }

    private static final class HaveAtomSourceElement
    extends TypeSafeDiagnosingMatcher<Entry> {
        private HaveAtomSourceElement() {
        }

        protected boolean matchesSafely(Entry item, Description mismatchDescription) {
            if (item.getExtension(Constants.SOURCE) == null) {
                mismatchDescription.appendText("no atom:source element");
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText("an atom:source element");
        }
    }

    private static final class WithUpdatedDate
    extends TypeSafeDiagnosingMatcher<Entry> {
        private final Matcher<? super Date> matcher;

        public WithUpdatedDate(Matcher<? super Date> matcher) {
            this.matcher = matcher;
        }

        protected boolean matchesSafely(Entry entry, Description mismatchDescription) {
            if (entry.getUpdated() == null) {
                mismatchDescription.appendText("no updated date");
                return false;
            }
            if (!this.matcher.matches((Object)entry.getUpdated())) {
                mismatchDescription.appendText("updated date ");
                this.matcher.describeMismatch((Object)entry.getUpdated(), mismatchDescription);
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText("updated date ").appendDescriptionOf(this.matcher);
        }
    }

    private static final class WithContent
    extends TypeSafeDiagnosingMatcher<Entry> {
        private final Matcher<? super String> matcher;

        public WithContent(Matcher<? super String> matcher) {
            this.matcher = matcher;
        }

        protected boolean matchesSafely(Entry entry, Description mismatchDescription) {
            if (entry.getContent() == null) {
                mismatchDescription.appendText("no content");
                return false;
            }
            if (!this.matcher.matches((Object)entry.getContent())) {
                mismatchDescription.appendText("content ");
                this.matcher.describeMismatch((Object)entry.getContent(), mismatchDescription);
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText("content ").appendDescriptionOf(this.matcher);
        }
    }

    private static final class WithEmptyContent
    extends TypeSafeDiagnosingMatcher<Entry> {
        private WithEmptyContent() {
        }

        protected boolean matchesSafely(Entry entry, Description mismatchDescription) {
            if (entry.getContent() == null) {
                return true;
            }
            mismatchDescription.appendText("content is not empty");
            return false;
        }

        public void describeTo(Description description) {
            description.appendText("content is empty");
        }
    }

    private static final class WithSummary
    extends TypeSafeDiagnosingMatcher<Entry> {
        private final Matcher<? super String> matcher;

        public WithSummary(Matcher<? super String> matcher) {
            this.matcher = matcher;
        }

        protected boolean matchesSafely(Entry entry, Description mismatchDescription) {
            if (entry.getSummary() == null) {
                mismatchDescription.appendText("no summary");
                return false;
            }
            if (!this.matcher.matches((Object)entry.getSummary())) {
                mismatchDescription.appendText("summary ");
                this.matcher.describeMismatch((Object)entry.getSummary(), mismatchDescription);
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText("summary ").appendDescriptionOf(this.matcher);
        }
    }

    private static final class WithType
    extends TypeSafeDiagnosingMatcher<ExtensibleElement> {
        private final Matcher<? super String> matcher;

        private WithType(Matcher<? super String> matcher) {
            this.matcher = matcher;
        }

        protected boolean matchesSafely(ExtensibleElement element, Description mismatchDescription) {
            if (!this.matcher.matches((Object)element.getSimpleExtension(AtomConstants.ACTIVITY_OBJECT_TYPE))) {
                mismatchDescription.appendText("activity:object-type ");
                this.matcher.describeMismatch((Object)element.getSimpleExtension(AtomConstants.ACTIVITY_OBJECT_TYPE), mismatchDescription);
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText("activity:object-type is ").appendDescriptionOf(this.matcher);
        }
    }

    private static final class WithId
    extends TypeSafeDiagnosingMatcher<ExtensibleElement> {
        private final Matcher<? super String> matcher;

        private WithId(Matcher<? super String> matcher) {
            this.matcher = matcher;
        }

        protected boolean matchesSafely(ExtensibleElement element, Description mismatchDescription) {
            if (!this.matcher.matches((Object)element.getSimpleExtension(Constants.ID))) {
                mismatchDescription.appendText("id ");
                this.matcher.describeMismatch((Object)element.getSimpleExtension(Constants.ID), mismatchDescription);
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText("id is ").appendDescriptionOf(this.matcher);
        }
    }

    private static final class WithText
    extends TypeSafeDiagnosingMatcher<Element> {
        private final Matcher<? super String> matcher;

        private WithText(Matcher<? super String> matcher) {
            this.matcher = matcher;
        }

        protected boolean matchesSafely(Element element, Description mismatchDescription) {
            if (!this.matcher.matches((Object)element.getText())) {
                mismatchDescription.appendText("title ");
                this.matcher.describeMismatch((Object)element.getText(), mismatchDescription);
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText("text is ").appendDescriptionOf(this.matcher);
        }
    }

    private static final class WithTerm
    extends TypeSafeDiagnosingMatcher<Category> {
        private final Matcher<? super String> matcher;

        private WithTerm(Matcher<? super String> matcher) {
            this.matcher = matcher;
        }

        protected boolean matchesSafely(Category category, Description mismatchDescription) {
            if (!this.matcher.matches((Object)category.getTerm())) {
                mismatchDescription.appendText("term ");
                this.matcher.describeMismatch((Object)category.getTerm(), mismatchDescription);
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText("term is").appendDescriptionOf(this.matcher);
        }
    }

    private static final class WithCategory
    extends TypeSafeDiagnosingMatcher<Entry> {
        private final Matcher<Category> matcher;

        private WithCategory(Matcher<Category> matcher) {
            this.matcher = matcher;
        }

        protected boolean matchesSafely(Entry entry, Description mismatchDescription) {
            for (Category category : entry.getCategories()) {
                if (!this.matcher.matches((Object)category)) continue;
                return true;
            }
            mismatchDescription.appendText("category ");
            this.matcher.describeMismatch((Object)entry.getCategories(), mismatchDescription);
            return false;
        }

        public void describeTo(Description description) {
            description.appendText("category has").appendDescriptionOf(this.matcher);
        }
    }

    private static final class WithTitle
    extends TypeSafeDiagnosingMatcher<Entry> {
        private final Matcher<? super String> matcher;

        private WithTitle(Matcher<? super String> matcher) {
            this.matcher = matcher;
        }

        protected boolean matchesSafely(Entry entry, Description mismatchDescription) {
            if (!this.matcher.matches((Object)entry.getTitle())) {
                mismatchDescription.appendText("title ");
                this.matcher.describeMismatch((Object)entry.getTitle(), mismatchDescription);
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText("title is").appendDescriptionOf(this.matcher);
        }
    }

    private static final class WhereHref
    extends TypeSafeDiagnosingMatcher<Link> {
        private final Matcher<? super String> matcher;

        public WhereHref(Matcher<? super String> matcher) {
            this.matcher = matcher;
        }

        protected boolean matchesSafely(Link link, Description mismatchDescription) {
            if (link == null) {
                mismatchDescription.appendText("no link");
                return false;
            }
            if (!this.matcher.matches((Object)link.getHref().toASCIIString())) {
                mismatchDescription.appendText("href ");
                this.matcher.describeMismatch((Object)link.getHref(), mismatchDescription);
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText("href ").appendDescriptionOf(this.matcher);
        }
    }

    private static final class WhereRel
    extends TypeSafeDiagnosingMatcher<Link> {
        private final Matcher<? super String> matcher;

        public WhereRel(Matcher<? super String> matcher) {
            this.matcher = matcher;
        }

        protected boolean matchesSafely(Link link, Description mismatchDescription) {
            if (link == null) {
                mismatchDescription.appendText("no link");
                return false;
            }
            if (!this.matcher.matches((Object)link.getRel())) {
                mismatchDescription.appendText("rel ");
                this.matcher.describeMismatch((Object)link.getRel(), mismatchDescription);
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText("rel ").appendDescriptionOf(this.matcher);
        }
    }

    private static final class WithLink
    extends TypeSafeDiagnosingMatcher<Element> {
        private final Matcher<Link> matcher;

        public WithLink(Matcher<Link> matcher) {
            this.matcher = matcher;
        }

        protected boolean matchesSafely(Element element, Description mismatchDescription) {
            Collection linkElements = Collections2.filter((Collection)element.getElements(), (Predicate)linkPredicate);
            if (linkElements.size() != 0) {
                for (Element linkElement : linkElements) {
                    Link link = (Link)linkElement;
                    if (this.matcher.matches((Object)link)) continue;
                    mismatchDescription.appendText("link ");
                    this.matcher.describeMismatch((Object)link, mismatchDescription);
                    return false;
                }
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText("link ").appendDescriptionOf(this.matcher);
        }
    }

    private static final class HasAuthor
    extends TypeSafeDiagnosingMatcher<Entry> {
        private final Matcher<Element> matcher;

        public HasAuthor(Matcher<Element> matcher) {
            this.matcher = matcher;
        }

        protected boolean matchesSafely(Entry entry, Description mismatchDescription) {
            if (entry.getAuthor() == null) {
                mismatchDescription.appendText("no author");
                return false;
            }
            if (!this.matcher.matches((Object)entry.getAuthor())) {
                mismatchDescription.appendText("author ");
                this.matcher.describeMismatch((Object)entry.getAuthor(), mismatchDescription);
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText("author ").appendDescriptionOf(this.matcher);
        }
    }

    private static final class IsTitleHtml
    extends TypeSafeDiagnosingMatcher<Entry> {
        private IsTitleHtml() {
        }

        protected boolean matchesSafely(Entry entry, Description mismatchDescription) {
            if (entry.getTitleType() == Text.Type.HTML) {
                return true;
            }
            mismatchDescription.appendText("title type is not HTML");
            return false;
        }

        public void describeTo(Description description) {
            description.appendText("title is html");
        }
    }

    private static final class WithPublishedDate
    extends TypeSafeDiagnosingMatcher<Entry> {
        private final Matcher<? super DateTime> matcher;

        public WithPublishedDate(Matcher<? super DateTime> matcher) {
            this.matcher = matcher;
        }

        protected boolean matchesSafely(Entry entry, Description mismatchDescription) {
            if (!this.matcher.matches((Object)new DateTime((Object)entry.getPublished()))) {
                mismatchDescription.appendText("publishedDate ");
                this.matcher.describeMismatch((Object)entry.getPublished(), mismatchDescription);
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText("publishedDate ").appendDescriptionOf(this.matcher);
        }
    }

    private static final class HasTarget
    extends TypeSafeDiagnosingMatcher<Entry> {
        private final Matcher<? super ExtensibleElement> matcher;

        public HasTarget(Matcher<? super ExtensibleElement> matcher) {
            this.matcher = matcher;
        }

        protected boolean matchesSafely(Entry entry, Description mismatchDescription) {
            List targets = entry.getExtensions(AtomConstants.ACTIVITY_TARGET);
            if (Iterables.isEmpty((Iterable)targets)) {
                mismatchDescription.appendText("no activity target");
                return false;
            }
            if (!this.matcher.matches(Iterables.getOnlyElement((Iterable)targets))) {
                mismatchDescription.appendText("target ");
                this.matcher.describeMismatch(Iterables.getOnlyElement((Iterable)targets), mismatchDescription);
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText("target where ").appendDescriptionOf(this.matcher);
        }
    }
}

