/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.api.common;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.regex.Pattern;

public class Predicates {
    public static Predicate<String> containsAnyString(Iterable<String> xs) {
        return com.google.common.base.Predicates.or((Iterable)Iterables.transform(xs, Predicates.containsString()));
    }

    public static Function<String, Predicate<String>> containsString() {
        return ContainsStringFunction.INSTANCE;
    }

    public static Predicate<String> containsString(String x) {
        return (Predicate)Predicates.containsString().apply((Object)x);
    }

    public static <A> Predicate<A> contains(Iterable<A> xs) {
        return new Contains(xs);
    }

    public static Predicate<String> containsAnyIssueKey(Iterable<String> keys) {
        return com.google.common.base.Predicates.or((Iterable)Iterables.transform(keys, Predicates.containsIssueKey()));
    }

    public static Predicate<String> containsIssueKey(String key) {
        return (Predicate)Predicates.containsIssueKey().apply((Object)key);
    }

    public static Function<String, Predicate<String>> containsIssueKey() {
        return ContainsIssueKeyFunction.INSTANCE;
    }

    private static final class ContainsIssueKey
    implements Predicate<String> {
        private final String key;
        private final Pattern pattern;

        public ContainsIssueKey(String key) {
            this.key = key;
            String regex = "(?<!CR-)\\b" + key + "\\b";
            this.pattern = Pattern.compile(regex);
        }

        public boolean apply(String input) {
            return this.pattern.matcher(input).find();
        }

        public String toString() {
            return String.format("containsIssueKey(%s)", this.key);
        }
    }

    private static enum ContainsIssueKeyFunction implements Function<String, Predicate<String>>
    {
        INSTANCE;


        public Predicate<String> apply(String key) {
            return new ContainsIssueKey(key);
        }
    }

    private static final class Contains<A>
    implements Predicate<A> {
        private final Iterable<A> xs;

        private Contains(Iterable<A> xs) {
            this.xs = xs;
        }

        public boolean apply(A x) {
            return Iterables.contains(this.xs, x);
        }

        public String toString() {
            return String.format("contains(%s)", this.xs);
        }
    }

    private static final class ContainsString
    implements Predicate<String> {
        private final String s;

        public ContainsString(String s) {
            this.s = s;
        }

        public boolean apply(String input) {
            return input.contains(this.s);
        }

        public String toString() {
            return String.format("containsString(%s)", this.s);
        }
    }

    private static enum ContainsStringFunction implements Function<String, Predicate<String>>
    {
        INSTANCE;


        public Predicate<String> apply(String s) {
            return new ContainsString(s);
        }
    }
}

